% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogs.R
\encoding{UTF-8}
\name{bde_catalog_search}
\alias{bde_catalog_search}
\title{Search BdE catalogs}
\usage{
bde_catalog_search(pattern, ...)
}
\arguments{
\item{pattern}{\code{\link[base:regex]{regex}}  pattern to search See \strong{Details}
and \strong{Examples}.}

\item{...}{
  Arguments passed on to \code{\link[=bde_catalog_load]{bde_catalog_load}}
  \describe{
    \item{\code{catalog}}{A single value indicating the catalogs to be updated
or \code{"ALL"} as a shorthand. See \strong{Details}.}
    \item{\code{parse_dates}}{Logical. If \code{TRUE} the dates would be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}
    \item{\code{update_cache}}{Logical. If \code{TRUE} the requested file would be updated on
the \code{cache_dir}.}
    \item{\code{cache_dir}}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}
    \item{\code{verbose}}{Logical \code{TRUE} or \code{FALSE}, display information useful for
debugging.}
  }}
}
\value{
A \code{\link[tibble:tibble]{tibble}} object with the results of the query.
}
\description{
Search for keywords on the time-series catalogs.
}
\details{
\strong{Note that} BdE files are only provided in Spanish, for the time being.
Therefore search terms should be provided in Spanish as well in order to get
search results.

This function uses \code{\link[base:grep]{base::grep()}} function for finding matches on
the catalogs. You can pass \link[base:regex]{regular expressions} to broaden
the search.
}
\examples{
\dontshow{if (bde_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Simple search (needs to be in Spanish)
# !! PIB [es] == GDP [en]

bde_catalog_search("PIB")

# More complex - Single
bde_catalog_search("Francia(.*)PIB")

# Even more complex - Double
bde_catalog_search("Francia(.*)PIB|Italia(.*)PIB|Alemania(.*)PIB")


# Search a sequential code: Exact match
# Note that this series (sequential code) appears on several tables

bde_catalog_search("^3779313$")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bde_catalog_load]{bde_catalog_load()}}, \link[base:regex]{base::regex}

Other catalog: 
\code{\link{bde_catalog_load}()},
\code{\link{bde_catalog_update}()}
}
\concept{catalog}
