% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIRTfit-methods.R
\name{predict.TIRTfit}
\alias{predict.TIRTfit}
\title{Predict trait scores of Thurstonian IRT models}
\usage{
\method{predict}{TIRTfit}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{TIRTfit}.}

\item{newdata}{Optional \code{TIRTdata} object (created via
\code{\link{make_TIRT_data}}) containing data of new persons
for which trait scores should be predicted based on the fitted
model. If \code{NULL} (the default), trait scores are predicted
for the persons whose data was used to originally fit the model.}

\item{...}{Further arguments passed to the underlying methods.}
}
\value{
A data frame with predicted trait scores.
}
\description{
Predict trait scores of Thurstonian IRT models
}
\details{
When predicting trait scores of new persons (via \code{newdata}),
  posterior medians of item parameters are used for predictions. This implies
  that the uncertainty in the new trait scores is underestimated as the
  uncertainty in the (posterior distribution of) item parameters is ignored.
}
