% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_plot.R
\name{sounding_plot}
\alias{sounding_plot}
\title{Plot Skew-T, hodograph and convective indices on a single layout}
\usage{
sounding_plot(
  pressure,
  altitude,
  temp,
  dpt,
  wd,
  ws,
  title = "",
  parcel = "MU",
  max_speed = 25,
  hazards = FALSE,
  ...
)
}
\arguments{
\item{pressure}{pressure [hPa]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as surface, i.e h = 0 m) - altitude [meters]}

\item{temp}{temperature [degree Celsius]}

\item{dpt}{dew point temperature [degree Celsius]}

\item{wd}{wind direction [azimuth in degrees]}

\item{ws}{wind speed [knots]}

\item{title}{title to be added in the layout's header}

\item{parcel}{parcel tracing on Skew-T for "MU", "ML" or "SB" parcel}

\item{max_speed}{range of the hodograph to be drawn, 25 m/s used as default}

\item{hazards}{logical, whether to add extra information about possibility of convective hazards given convective initiation (default  = FALSE)}

\item{...}{extra graphic arguments}
}
\value{
Skew-T, hodograph and table with convective indices drawn on a pre-defined single layout
}
\description{
Function to plot a composite of Skew-T, hodograph and selected convective parameters on a single layout
}
\examples{
data("sounding_vienna")
sounding_vienna = na.omit(sounding_vienna)
attach(sounding_vienna)
sounding_plot(pressure, altitude, temp, dpt, wd, ws, 
              parcel = "MU", title = "Vienna - 23 August 2011, 12:00 UTC")

}
