% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,coxph.penal-method}
\alias{extract,coxph.penal-method}
\alias{extract.coxph.penal}
\title{\code{\link{extract}} method for \code{coxph.penal} objects}
\usage{
\S4method{extract}{coxph.penal}(
  model,
  include.aic = TRUE,
  include.rsquared = TRUE,
  include.maxrs = TRUE,
  include.events = TRUE,
  include.nobs = TRUE,
  include.missings = TRUE,
  include.zph = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.maxrs}{Report maximal R^2 in the GOF block?}

\item{include.events}{Report the number of events in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.missings}{Report number of missing data points in the GOF
block?}

\item{include.zph}{Report proportional hazard test in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{coxph.penal} objects created by the
\code{\link[survival]{coxph}} function in the \pkg{survival} package.
}
