% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,H2OBinomialModel-method}
\alias{extract,H2OBinomialModel-method}
\alias{extract.H2OBinomialModel}
\title{\code{\link{extract}} method for \code{H2OBinomialModel} objects}
\usage{
\S4method{extract}{H2OBinomialModel}(
  model,
  standardized = FALSE,
  include.mse = TRUE,
  include.rsquared = TRUE,
  include.logloss = TRUE,
  include.meanerror = TRUE,
  include.auc = TRUE,
  include.gini = TRUE,
  include.deviance = TRUE,
  include.aic = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{standardized}{Report standardized coefficients instead of raw
coefficients?}

\item{include.mse}{Report the mean squared error in the GOF block?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.logloss}{Report the log loss?}

\item{include.meanerror}{Report the mean per-class error?}

\item{include.auc}{Report the area under the curve (AUC)?}

\item{include.gini}{Report the Gini coefficient?}

\item{include.deviance}{Report the deviance?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{...}{Custom parameters, which are handed over to subroutines. Currently
not in use.}
}
\description{
\code{\link{extract}} method for \code{H2OBinomialModel} objects created by
the \code{\link[h2o]{h2o.glm}} function in the \pkg{h2o} package.
}
