% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoff_functions.R
\name{kendalltau}
\alias{kendalltau}
\title{Kendall's tau measure of association.}
\usage{
kendalltau(x, y, nmc = 1e+05)
}
\arguments{
\item{x}{a vector.}

\item{y}{a vector.}

\item{nmc}{an integer number of Monte Carlo simulations.}
}
\value{
A Monte Carlo approximation to Kendall's tau measure of
    association.
}
\description{
This function provides a Monte Carlo approximation to Kendall's tau
measure of association.
}
\examples{
mu <- rexp(30)
tensr:::kendalltau(rpois(30, mu), rpois(30, mu))

}
\author{
Peter Hoff.
}

