% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{start_server}
\alias{start_server}
\title{Start the webhook server.}
\usage{
start_server(host = "127.0.0.1", port = 5001, clean = FALSE, blocking = TRUE)
}
\arguments{
\item{host}{a string that is a valid IPv4 or IPv6 address that is owned by
this server, which the application will listen on. "0.0.0.0" represents
all IPv4 addresses and "::/0" represents all IPv6 addresses.
Default is "127.0.0.1".}

\item{port}{a number or integer that indicates the server port that should
be listened on. Note that on most Unix-like systems including Linux and
Mac OS X, port numbers smaller than 1025 require root privileges.
Default is 5001.}

\item{clean}{(Optional). Whether to clean any pending updates on Telegram
servers before actually starting to poll. Default is \code{FALSE}.}

\item{blocking}{(Optional). Determines whether the method blocks whilst listening
for updates from Telegram.
Default is \code{TRUE}.}
}
\description{
Starts the webhook for updates from Telegram. You can stop listening either by
using the RStudio's \code{interrupt R} command in the session menu or with the
\code{\link{stop_server}} method.
}
\examples{
\dontrun{
# Start webhook example
start <- function(bot, update) {
  bot$sendMessage(
    chat_id = update$message$chat_id,
    text = sprintf(
      "Hello \%s!",
      update$message$from$first_name
    )
  )
}

webhook <- Webhook("https://example.com/webhook", "TOKEN") + CommandHandler("start", start)

webhook$start_server()
}
}
