% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_spec.R
\name{select_spec}
\alias{select_spec}
\alias{select_spec.delayed_data}
\alias{select_spec.default}
\title{Column selection input specification}
\usage{
select_spec(
  choices,
  selected = if (inherits(choices, "delayed_data")) NULL else choices[1],
  multiple = length(selected) > 1 || inherits(selected, "multiple_choices"),
  fixed = FALSE,
  always_selected = NULL,
  ordered = FALSE,
  label = "Select"
)

select_spec.delayed_data(
  choices,
  selected = NULL,
  multiple = length(selected) > 1,
  fixed = FALSE,
  always_selected = NULL,
  ordered = FALSE,
  label = NULL
)

select_spec.default(
  choices,
  selected = choices[1],
  multiple = length(selected) > 1,
  fixed = FALSE,
  always_selected = NULL,
  ordered = FALSE,
  label = NULL
)
}
\arguments{
\item{choices}{(\code{character} or \code{delayed_data}) object.
Named character vector to define the choices of a shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}.
These have to be columns in the dataset defined in the \code{\link[=data_extract_spec]{data_extract_spec()}}
where this is called.
\code{delayed_data} objects can be created via \code{\link[=variable_choices]{variable_choices()}} or \code{\link[=value_choices]{value_choices()}}.}

\item{selected}{(\code{character} or \code{NULL} or \code{delayed_choices} or \code{delayed_data}) optional
named character vector to define the selected values of a shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}.
Passing a \code{delayed_choices} object defers selection until data is available.
Defaults to the first value of \code{choices} or \code{NULL} for delayed data loading.}

\item{multiple}{(\code{logical}) Whether multiple values shall be allowed in the
shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}.}

\item{fixed}{(\code{logical}) optional \code{\link[=data_extract_spec]{data_extract_spec()}} specific feature to
hide the choices selected in case they are not needed. Setting fixed to \code{TRUE}
will not allow the user to select columns. It will then lead to a selection of
columns in the dataset that is defined by the developer of the app.}

\item{always_selected}{(\code{character}) Additional column names from the data set that should
always be selected}

\item{ordered}{(\code{logical(1)}) Flags whether selection order should be tracked.}

\item{label}{(\code{character}) optional, defines a label on top of this specific
shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}. The default value is \code{"Select"}.}
}
\value{
A \code{select_spec}-S3 class object or \code{delayed_select_spec}-S3-class object.
It contains all input values.

If \code{select_spec}, then the function double checks the \code{choices} and \code{selected} inputs.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{select_spec} is used inside \code{teal} to create a \code{\link[shiny:selectInput]{shiny::selectInput()}}
that will select columns from a dataset.
}
\examples{
# Selection with just one column allowed
select_spec(
  choices = c("AVAL", "BMRKR1", "AGE"),
  selected = c("AVAL"),
  multiple = FALSE,
  fixed = FALSE,
  label = "Column"
)

# Selection with just multiple columns allowed
select_spec(
  choices = c("AVAL", "BMRKR1", "AGE"),
  selected = c("AVAL", "BMRKR1"),
  multiple = TRUE,
  fixed = FALSE,
  label = "Columns"
)

# Selection without user access
select_spec(
  choices = c("AVAL", "BMRKR1"),
  selected = c("AVAL", "BMRKR1"),
  multiple = TRUE,
  fixed = TRUE,
  label = "Columns"
)

# Delayed version
select_spec(
  label = "Select variable:",
  choices = variable_choices("ADSL", c("BMRKR1", "BMRKR2")),
  selected = "BMRKR1",
  multiple = FALSE,
  fixed = FALSE
)

# delayed_choices passed to selected
select_spec(
  label = "Select variable:",
  choices = variable_choices("ADSL", c("BMRKR1", "BMRKR2")),
  selected = all_choices()
)

# Both below objects are semantically the same
select_spec(choices = variable_choices("ADSL"), selected = variable_choices("ADSL"))
select_spec(choices = variable_choices("ADSL"), selected = all_choices())
}
