% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tl_create.R
\name{tl_create}
\alias{tl_create}
\title{Create a Lightning Memory-Mapped Database (LMDB) for a given provider}
\usage{
tl_create(
  provider = getOption("tl_default_provider", "itis"),
  version = tl_latest_version(),
  dir = tl_dir(),
  lines = 100000L
)
}
\arguments{
\item{provider}{Abbreviation for a known naming provider.
Provider data should first be imported with \verb{[tl_create]}.
Note: setting provider to \code{"itis_test"} is for testing purposes only,
use \code{"itis"} for the full ITIS data.  See details}

\item{version}{version of the authority to use (e.g. four-digit year)}

\item{dir}{storage location for the LMDB databases}

\item{lines}{number of lines to read in each chunk.}
}
\description{
Download raw data and store in a local LMDB database.  Importing
data is a time-consuming step that needs be run only once per
machine and will persist through sessions.
}
\details{
Naming providers currently recognized by \code{taxalight} are:
\itemize{
\item \code{itis}: Integrated Taxonomic Information System, \url{https://www.itis.gov/}
\item \code{ncbi}:  National Center for Biotechnology Information,
\url{https://www.ncbi.nlm.nih.gov/taxonomy}
\item \code{col}: Catalogue of Life, \url{http://www.catalogueoflife.org/}
\item \code{gbif}: Global Biodiversity Information Facility, \url{https://www.gbif.org/}
\item \code{ott}: OpenTree Taxonomy: \url{https://github.com/OpenTreeOfLife/reference-taxonomy}
\item \code{itis_test}: a small subset of ITIS, cached locally for testing purposes only.
}

The default provider is \code{itis}, which can be reconfigured by setting
\code{tl_default_provider} in \verb{[options]}.
}
\examples{

## example uses "itis_test" for illustration only:

\dontshow{Sys.setenv(TAXALIGHT_HOME=tempfile())}
tl_create("itis_test")
\dontshow{Sys.unsetenv("TAXALIGHT_HOME")}

}
