% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nl_pat_fam_prices.R
\name{nl_pat_fam_prices}
\alias{nl_pat_fam_prices}
\title{A function to download the Patient & Family Reference prices of the Dutch Costing Manual for one or multiple years}
\usage{
nl_pat_fam_prices(
  year = "all",
  category = "all",
  unit = "all",
  currency = c("EUR", "INT$")
)
}
\arguments{
\item{year}{The year of which the reference price should be downloaded, multiple years are possible, default is the whole dataset (year = "all")}

\item{category}{The category of prices that should be included (one or more categories), default is including all categories}

\item{unit}{The reference price that should be included (one or multiple reference prices),  default is including the whole data frame}

\item{currency}{The currency of the output of the prices. A decision can be made between EUR and INT$, the default is EUR.}
}
\value{
A dataframe or value with the Patient & Family Reference price(s) of the Dutch Costing Manual for the specified years
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function downloads the Patient & Family Reference prices of the Dutch Costing Manual for one or multiple years. The prices are available in Euro (EUR) or International Dollar (INT$).
}
\examples{
# Example usage of the nl_pat_fam_prices function
# Calculate for 2023 with the category Transportation and the unit Car, cost per kilometer in EURO
nl_pat_fam_prices(year = "2022", category = "Transportation", unit = "Car, cost per kilometer")

# Calculate for year 2022 and 2023 the unit Car, cost per kilometer in EURO
nl_pat_fam_prices(year = "all", unit = "Car, cost per kilometer")

# Calculate for the year 2022 with the category Transportation in INT$
nl_pat_fam_prices(year = "2022", category = "Transportation", currency = "INT$")

}

\keyword{Costing}
\keyword{Dutch}
\keyword{Family}
\keyword{Generic}
\keyword{Patient}
\keyword{Prices}
