% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_latex.R
\name{as_latex.Mashed_table}
\alias{as_latex.Mashed_table}
\title{Convert a Mashed Table to Latex Code}
\usage{
\method{as_latex}{Mashed_table}(
  x,
  mash_method = attr(x, "mash_method"),
  id_vars = attr(x, "id_vars"),
  insert_blank_row = attr(x, "insert_blank_row"),
  sep_height = attr(x, "sep_height"),
  ...,
  kable_options = default_kable_options()
)
}
\arguments{
\item{x}{a \code{\link{Tatoo_table}}, \code{data.frame} or a list of \code{data.frame}s}

\item{mash_method}{either \code{"row"} or \code{"col"}. Should the tables be mashed
together with alternating rows or with alternating columns?}

\item{id_vars}{Only if mashing columns: one ore more colnames of the tables
to be mashed. If supplied, columns of both input tables are combined with
\code{\link[=merge]{merge()}}, otherwise \code{\link[=cbind]{cbind()}} is used.}

\item{insert_blank_row}{Only if mashing rows: logical. Whether to insert
blank rows between mash-groups. \emph{Warning: this converts all columns to
character.} Use with care.}

\item{sep_height}{Only has an effect when exporting to \code{xlsx}. if
\code{insert_blank_row == TRUE}, height of the inserted row, else height of the
top row of each mash-group.}

\item{...}{\code{mash_table()} only: \code{data.frames} with the same row and column
count. Elements of \code{(...)} can be named, but the name must differ from
the argument names of this function.}

\item{kable_options}{\code{list}. Options passed on to \code{\link[knitr:kable]{knitr::kable()}}. See
\code{\link[=default_kable_options]{default_kable_options()}} for details.}
}
\value{
\code{as_latex()}returns a \code{character} scalar of Latex code

\code{save_pdf()} returns a the path to the saved file as \code{character}
scalar.

\code{view_pdf()} returns \code{NULL} (invisibly)
}
\description{
Convert a Mashed Table to Latex Code
}
\seealso{
Other as_latex methods: 
\code{\link{as_latex.Composite_table}()},
\code{\link{as_latex.Tagged_table}()},
\code{\link{as_latex.Tatoo_report}()},
\code{\link{as_latex.data.frame}()},
\code{\link{as_latex}()}
}
\concept{as_latex methods}
