% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_seed_get.R
\name{tar_seed_get}
\alias{tar_seed_get}
\title{Get the random number generator seed of the target currently running.}
\usage{
tar_seed_get(default = 1L)
}
\arguments{
\item{default}{Integer, value to return if \code{tar_seed_get()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}
}
\value{
Integer of length 1. If invoked inside a \code{targets} pipeline,
the return value is the seed of the target currently running,
which is a deterministic function of the target name. Otherwise,
the return value is \code{default}.
}
\description{
Get the random number generator seed
of the target currently running.
}
\section{Seeds}{

A target's random number generator seed
is a deterministic function of its name and the global pipeline seed
from \code{tar_option_get("seed")}. Consequently,

\if{html}{\out{<div class="sourceCode">}}\preformatted{1. Each target runs with a reproducible seed so that
   different runs of the same pipeline in the same computing
   environment produce identical results.
2. No two targets in the same pipeline share the same seed.
   Even dynamic branches have different names and thus different seeds.
}\if{html}{\out{</div>}}

You can retrieve the seed of a completed target
with \code{tar_meta(your_target, seed)}
and run \code{\link[=tar_seed_set]{tar_seed_set()}} on the result to locally
recreate the target's initial RNG state. \code{\link[=tar_workspace]{tar_workspace()}}
does this automatically as part of recovering a workspace.
}

\section{RNG overlap}{

In theory, there is a risk that the pseudo-random number generator
streams of different targets will overlap and produce statistically
correlated results. (For a discussion of the motivating problem,
see the Section 6: "Random-number generation" in the \code{parallel}
package vignette: \code{vignette(topic = "parallel", package = "parallel")}.)
However, this risk is extremely small in practice, as shown by
L'Ecuyer et al. (2017) \doi{10.1016/j.matcom.2016.05.005}
under "A single RNG with a 'random' seed for each stream" (Section 4:
under "How to produce parallel streams and substreams").

\code{targets} and \code{tarchetypes} take the approach discussed in the
aforementioned section of the paper, where \code{\link[=tar_seed_create]{tar_seed_create()}} plays the
role of the upstream pseudo-random number generator (RNG) that produces
seeds for the subsequent parallel streams. Specifically,
\code{\link[=tar_seed_create]{tar_seed_create()}} acts as a counter-based RNG,
where the output function is the SHA512 hash algorithm.
(See "counter-based RNGs" under Section 3: "Main classes of RNGs
for simulation".) There are two notable quirks, but they are innocuous:

\if{html}{\out{<div class="sourceCode">}}\preformatted{1. Instead of a recursive integer counter, [tar_seed_create()] accepts
   the name of the target as the argument.
   Because target names map to small integers, this is equivalent to
   traversing the RNG sequence in variable small jumps. This does not
   affect the period length, and the argument in Section 4 of
   L'Ecuyer et al. (2017) still holds.
2. [tar_seed_create()] converts the SHA512 hash into an
   integer using `digest::digest2int()`. This is necessary
   because integers in R can only be 32 bits. `set.seed()`
   cannot accept anything greater.
}\if{html}{\out{</div>}}
}

\examples{
tar_seed_get()
tar_seed_get(default = 123L)
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(tar_target(returns_seed, tar_seed_get()), ask = FALSE)
tar_make()
tar_read(returns_seed)
})
}
}
\references{
Pierre L'Ecuyer, David Munger, Boris Oreshkin, and Richard Simard
(2017). Random numbers for parallel computers: Requirements and methods,
with emphasis on GPUs. Mathematics and Computers in Simulation,
135, 3-17. \doi{10.1016/j.matcom.2016.05.005}.
}
\seealso{
Other pseudo-random number generation: 
\code{\link{tar_seed_create}()},
\code{\link{tar_seed_set}()}
}
\concept{pseudo-random number generation}
