% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_cue.R
\name{tar_cue}
\alias{tar_cue}
\title{Declare the rules that cue a target.}
\usage{
tar_cue(
  mode = c("thorough", "always", "never"),
  command = TRUE,
  depend = TRUE,
  format = TRUE,
  iteration = TRUE,
  file = TRUE
)
}
\arguments{
\item{mode}{Cue mode. If \code{"thorough"}, all the cues apply unless
individually suppressed. If \code{"always"}, then the target always
runs. If \code{"never"}, then the target does not run unless the
metadata does not exist or the last run errored.}

\item{command}{Logical, whether to rerun the target if command changed
since last time.}

\item{depend}{Logical, whether to rerun the target if the value of one
of the dependencies changed.}

\item{format}{Logical, whether to rerun the target if the user-specified
storage format changed. The storage format is user-specified through
\code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}.}

\item{iteration}{Logical, whether to rerun the target if the user-specified
iteration method changed. The iteration method is user-specified through
\code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}.}

\item{file}{Logical, whether to rerun the target if the file(s) with the
return value changed or at least one is missing.}
}
\description{
Declare the rules that mark a target as outdated.
}
\section{Target invalidation rules}{

\code{targets} uses internal metadata and special cues
to decide whether a target is up to date (can skip)
or is outdated/invalidated (needs to rerun). By default,
\code{targets} moves through the following list of cues
and declares a target outdated if at least one is cue activated.
\enumerate{
\item There is no metadata record of the target.
\item The target errored last run.
\item The target has a different class than it did before.
\item The cue mode equals \code{"always"}.
\item The cue mode does not equal \code{"never"}.
\item The \code{command} metadata field (the hash of the R command)
is different from last time.
\item The \code{depend} metadata field (the hash of the immediate upstream
dependency targets and global objects) is different from last time.
\item The storage format is different from last time.
\item The iteration mode is different from last time.
\item A target's file (either the one in \verb{_targets/objects/}
or a dynamic file) does not exist or changed since last time.
}

The user can suppress many of the above cues using the \code{tar_cue()}
function, which creates the \code{cue} argument of \code{\link[=tar_target]{tar_target()}}.
Cues objects also constitute more nuanced target invalidation rules.
The \code{tarchetypes} package has many such examples, including
\code{tar_age()}, \code{tar_download()}, \code{tar_cue_age()}, \code{tar_cue_force()},
and \code{tar_cue_skip()}.
}

\section{Dependency-based invalidation and user-defined functions}{

If the cue of a target has \code{depend = TRUE} (default) then the target
is marked invalidated/outdated when its upstream dependencies change.
A target's dependencies include upstream targets,
user-defined functions, and other global objects populated
in the target script file (default: \verb{_targets.R}).
To determine if a given dependency changed
since the last run of the pipeline, \code{targets} computes hashes.
The hash of a target is computed on its files in storage
(usually a file in \verb{_targets/objects/}). The hash of a
non-function global object dependency is computed directly on its
in-memory data. User-defined functions are hashed in the following way:
\enumerate{
\item Deparse the function with \code{targets:::tar_deparse_safe()}. This
function computes a string representation of the function
body and arguments. This string representation is invariant to
changes in comments and whitespace, which means
trivial changes to formatting do not cue targets to rerun.
\item Manually remove any literal pointers from the function string
using \code{targets:::mask_pointers()}. Such pointers arise from
inline compiled C/C++ functions.
\item Using static code analysis (i.e. \code{\link[=tar_deps]{tar_deps()}}, which is based on
\code{codetools::findGlobals()}) identify any user-defined functions
and global objects that the current function depends on.
Append the hashes of those dependencies to the string representation
of the current function.
\item Compute the hash of the final string representation using
\code{targets:::digest_chr64()}.
}

Above, (3) is important because user-defined functions
have dependencies of their own, such as other user-defined
functions and other global objects. (3) ensures that a change to
a function's dependencies invalidates the function itself, which
in turn invalidates any calling functions and any targets downstream
with the \code{depend} cue turned on.
}

\examples{
# The following target will always run when the pipeline runs.
x <- tar_target(x, download_data(), cue = tar_cue(mode = "always"))
}
\seealso{
Other targets: 
\code{\link{tar_format}()},
\code{\link{tar_target_raw}()},
\code{\link{tar_target}()}
}
\concept{targets}
