% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.checkMaximum.R
\name{constraints.checkMaximum}
\alias{constraints.checkMaximum}
\title{Check if maximum constraint is met}
\usage{
constraints.checkMaximum(constraint, value)
}
\arguments{
\item{constraint}{numeric constraint value}

\item{value}{numeric value to meet the constraint}
}
\value{
TRUE if value is equal to or less than the constraint
}
\description{
Specifies a maximum value for a field. This is different to \code{maxLength} which checks the number of items in the value. 
A maximum value constraint checks whether a field value is equal to or less than the specified value. 
The range checking depends on the type of the field. E.g. an integer field may have a maximum value of 100.
If a maximum value constraint is specified then the field descriptor \code{MUST} contain a type key.
}
\examples{

constraints.checkMaximum(constraint = list(2), value = 1)

constraints.checkMaximum(constraint = 2, value = 3)

}
\seealso{
\href{https://frictionlessdata.io/specs/table-schema/#constraints}{Constraints specifications}
}
