% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\docType{class}
\name{Profile}
\alias{Profile}
\title{Profile class}
\format{\code{\link{R6Class}} object.}
\usage{
# Profile.load(profile)
}
\value{
Object of \code{\link{R6Class}} .
}
\description{
Class to represent JSON Schema profile from \href{https://frictionlessdata.io/schemas/registry.json}{Profiles Registry}.
}
\section{Methods}{

\describe{

\item{\code{Profile$new(descriptor = descriptor)}}{
Use \code{\link{Profile.load}} to instantiate \code{Profile} class.}

  \item{\code{validate(descriptor)}}{
Validate a tabular data package descriptor against the \code{Profile}.}
\itemize{
 \item{\code{descriptor }}{Retrieved and dereferenced tabular data package descriptor.}  
 \item{\code{(Object) }}{Returns \code{TRUE} if descriptor is valid or \code{FALSE} with error message.}
 }

}
}

\section{Properties}{

\describe{
  \item{\code{name}}{Returns profile name if available.}
  \item{\code{jsonschema}}{Returns profile JSON Schema contents.}
}
}

\seealso{
\href{http://frictionlessdata.io/specs/profiles/}{Profile Specifications}
}
\keyword{data}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Profile$new()}}
\item \href{#method-validate}{\code{Profile$validate()}}
\item \href{#method-clone}{\code{Profile$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Profile$new(profile)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{profile}}{string profile name in registry or URL to JSON Schema}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-validate"></a>}}
\subsection{Method \code{validate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Profile$validate(descriptor)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Profile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
