% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_fonts.R
\name{match_fonts}
\alias{match_fonts}
\alias{match_font}
\title{Find a system font by name and style}
\usage{
match_fonts(family, italic = FALSE, weight = "normal", width = "undefined")

match_font(family, italic = FALSE, bold = FALSE)
}
\arguments{
\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{bold}{logical indicating whether the font weight}
}
\value{
A list containing the paths locating the font files, the 0-based
index of the font in the files and the features for the font in case a
registered font was located.
}
\description{
This function locates the font file (and index) best matching a name and
optional style. A font file will be returned even if a perfect match
isn't found, but it is not necessarily similar to the requested family and
it should not be relied on for font substitution. The aliases \code{"sans"},
\code{"serif"}, \code{"mono"}, \code{"symbol"}, and \code{"emoji"} match to their respective
system defaults (\code{""} is equivalent to \code{"sans"}). \code{match_font()} has been
deprecated in favour of \code{match_fonts()} which provides vectorisation, as well
as querying for different weights (rather than just "normal" and "bold") as
well as different widths.
}
\section{Font matching}{
During font matching, systemfonts has to look in three different locations.
The font registry (populated by \code{\link[=register_font]{register_font()}}/\code{\link[=register_variant]{register_variant()}}), the
local fonts (populated with \code{\link[=add_fonts]{add_fonts()}}/\code{\link[=scan_local_fonts]{scan_local_fonts()}}), and the
fonts installed on the system. It does so in that order: registry > local >
installed.

The matching performed at each step also differs. The fonts in the registry
is only matched by family name. The local fonts are matched based on all the
provided parameters (family, weight, italic, etc) in a way that is local to
systemfonts, but try to emulate the system native matching. The installed
fonts are matched using the system native matching functionality on macOS and
Linux. On Windows the installed fonts are read from the system registry and
matched using the same approach as for local fonts. Matching will always find
a font no matter what you throw at it, defaulting to "sans" if nothing else
is found.
}

\examples{
# Get the system default sans-serif font in italic
match_fonts('sans', italic = TRUE)

# Try to match it to a thin variant
match_fonts(c('sans', 'serif'), weight = "thin")

}
