% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semaxis.R
\name{semaxis}
\alias{semaxis}
\title{Characterise word semantics using the SemAxis framework}
\usage{
semaxis(w, S_words, A_words, B_words, l = 0, verbose = FALSE)
}
\arguments{
\item{w}{a numeric matrix of word embeddings (e.g. from \code{\link[rsparse:GloVe]{rsparse::GloVe()}})}

\item{S_words}{a character vector of the first set of target words. In an example of studying gender stereotype, it can include occupations such as programmer, engineer, scientists...}

\item{A_words}{a character vector of the first set of attribute words. In an example of studying gender stereotype, it can include words such as man, male, he, his.}

\item{B_words}{a character vector of the second set of attribute words. In an example of studying gender stereotype, it can include words such as woman, female, she, her.}

\item{l}{an integer indicates the number of words to augment each word in A and B based on cosine , see An et al (2018). Default to 0 (no augmentation).}

\item{verbose}{logical, whether to display information}
}
\value{
A list with class \code{"semaxis"} containing the following components:
\describe{
\item{\code{$P}}{for each of words in S, the score according to SemAxis}
\item{\code{$V}}{the semantic axis vector}
\item{\code{$S_words}}{the input S_words}
\item{\code{$A_words}}{the input A_words}
\item{\code{$B_words}}{the input B_words}
}
}
\description{
This function calculates the axis and the score using the SemAxis framework proposed in An et al (2018). If possible, please use \code{\link[=query]{query()}} instead.
}
\examples{
data(glove_math)
S1 <- c("math", "algebra", "geometry", "calculus", "equations",
"computation", "numbers", "addition")
A1 <- c("male", "man", "boy", "brother", "he", "him", "his", "son")
B1 <- c("female", "woman", "girl", "sister", "she", "her", "hers", "daughter")
semaxis(glove_math, S1, A1, B1, l = 0)$P
}
\references{
An, J., Kwak, H., & Ahn, Y. Y. (2018). \href{https://arxiv.org/abs/1806.05521}{SemAxis: A lightweight framework to characterize domain-specific word semantics beyond sentiment.} arXiv preprint arXiv:1806.05521.
}
\author{
Chung-hong Chan
}
