% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweater.R
\name{weat_es}
\alias{weat_es}
\title{Calculation of WEAT effect size}
\usage{
weat_es(x, standardize = TRUE, r = FALSE)
}
\arguments{
\item{x}{an object from the \link{weat} function.}

\item{standardize}{a boolean to denote whether to correct the difference by the standard division. The standardized version can be interpreted the same way as Cohen's d.}

\item{r}{a boolean to denote whether convert the effect size to biserial correlation coefficient.}
}
\value{
the effect size of the query
}
\description{
This function calculates the effect size from a sweater object. The original implementation in Caliskan et al. (2017) assumes the numbers of words in S and in T must be equal. The current implementation eases this assumption by adjusting the variance with the difference in sample sizes. It is also possible to convert the Cohen's d to Pearson's correlation coefficient (r).
}
\examples{
# Reproduce the number in Caliskan et al. (2017) - Table 1, "Math vs. Arts"
data(glove_math)
S1 <- c("math", "algebra", "geometry", "calculus", "equations",
"computation", "numbers", "addition")
T1 <- c("poetry", "art", "dance", "literature", "novel", "symphony", "drama", "sculpture")
A1 <- c("male", "man", "boy", "brother", "he", "him", "his", "son")
B1 <- c("female", "woman", "girl", "sister", "she", "her", "hers", "daughter")
sw <- weat(glove_math, S1, T1, A1, B1)
weat_es(sw)
}
\references{
Caliskan, A., Bryson, J. J., & Narayanan, A. (2017). Semantics derived automatically from language corpora contain human-like biases. Science, 356(6334), 183-186.
}
\author{
Chung-hong Chan
}
