% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survdnn.R
\name{build_dnn}
\alias{build_dnn}
\title{Build a Deep Neural Network for Survival Analysis}
\usage{
build_dnn(input_dim, hidden, activation = "relu", output_dim = 1L)
}
\arguments{
\item{input_dim}{Integer. Number of input features.}

\item{hidden}{Integer vector. Sizes of the hidden layers (e.g., c(32, 16)).}

\item{activation}{Character. Name of the activation function to use in each layer.
Supported options: `"relu"`, `"leaky_relu"`, `"tanh"`, `"sigmoid"`, `"gelu"`, `"elu"`, `"softplus"`.}

\item{output_dim}{Integer. Output layer dimension (default = 1).}
}
\value{
A `nn_sequential` object representing the network.
}
\description{
Constructs a multilayer perceptron (MLP) with batch normalization,
activation functions, and dropout. Used internally by [survdnn()] to
define the model architecture.
}
\examples{
net <- build_dnn(10, hidden = c(64, 32), activation = "relu")
}
\keyword{internal}
