\name{bws2.questionnaire}
\alias{bws2.questionnaire}



\title{
Converting an orthogonal main-effect design into Case 2 best--worst scaling 
questions
}



\description{
This function converts an orthogonal main-effect design into a series of 
Case 2 best--worst scaling questions.
}


\usage{
bws2.questionnaire(choice.sets, attribute.levels = NULL, 
  position = c("left", "center", "right"))
}


\arguments{
  \item{choice.sets}{
A data frame or matrix containing an orthogonal main-effect design.
}
  \item{attribute.levels}{
A list containing the names of attributes and their levels.
}
  \item{position}{
A character showing the position where attribute levels are shown 
in questions.
}
}



\details{
The \code{bws2.questionnaire()} function converts an orthogonal main-effect 
design (OMED) into a series of Case 2 best--worst scaling (BWS) questions 
and then displays the resultant questions on an R console.

An OMED is assigned to the argument \code{choice.sets}, 
which may be generated by R functions such as \code{oa.design()} 
in \pkg{DoE.base} or manually copied from text books or websites 
related to experimental designs. 

Attributes and their levels are assigned to the argument 
\code{attribute.levels} in list format. For example, suppose that 
profiles have four attributes, each of which has three levels: 
attribute A with levels A1, A2, and A3; attribute B with levels B1, B2, 
and B3; attribute C with levels C1, C2, and C3; and attribute D with 
levels D1, D2, and D3. In this case, the argument is set as follows:

\code{attribute.levels = list(} \cr
\code{    A = c("A1", "A2", "A3"),} \cr
\code{    B = c("B1", "B2", "B3"),} \cr
\code{    C = c("C1", "C2", "C3"),} \cr
\code{    D = c("D1", "D2", "D3"))} \cr

The argument \code{position} is used to change the position of the attribute 
column in the resultant questions. When setting \code{position = "left"}, 
the attribute column is located on the left-hand side as follows:

\code{Q1} \cr
\code{ Attribute Best Worst} \cr
\code{ A1        [ ]  [ ]} \cr
\code{ B1        [ ]  [ ]} \cr
\code{ C1        [ ]  [ ]} \cr
\code{ D1        [ ]  [ ]}

When setting \code{position = "center"}, the attribute column is located 
in the center as follows:

\code{Q1} \cr
\code{ Best Attribute Worst} \cr
\code{ [ ]  A1        [ ]} \cr
\code{ [ ]  B1        [ ]} \cr
\code{ [ ]  C1        [ ]} \cr
\code{ [ ]  D1        [ ]}

When setting \code{position = "right"}, the attribute column is located 
on the right-hand side as follows:

\code{Q1} \cr
\code{ Best Worst Attribute} \cr
\code{ [ ]  [ ]   A1} \cr
\code{ [ ]  [ ]   B1} \cr
\code{ [ ]  [ ]   C1} \cr
\code{ [ ]  [ ]   D1}
}



\value{
BWS questions converted from the design are returned. 
}



\author{
Hideo Aizaki
}



\seealso{
\code{\link{support.BWS2-package}}, 
\code{\link{bws2.dataset}}, 
\code{\link[DoE.base]{oa.design}}
}
\examples{
## See examples in bws2.dataset()
}



\keyword{ print }
