% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printRegnTables.R
\name{printRegnTables}
\alias{printRegnTables}
\title{Print estimated regression tables}
\usage{
printRegnTables(
  x,
  topics = NULL,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{the estimated regression tables from estimateRegnTables()}

\item{topics}{Vector of topics to display. Defaults to all topics.}

\item{digits}{minimum number of significant digits to be used for most numbers.}

\item{signif.stars}{logical; if TRUE, P-values are additionally encoded 
visually as ‘significance stars’ in order to help scanning of long 
coefficient tables. It defaults to the show.signif.stars slot of options.}

\item{...}{other arguments suitable for stats::printCoefmat()}
}
\value{
Prints estimated regression tables from estimateRegnTables() to console
}
\description{
Prints estimated regression tables from estimateRegnTables()
}
\examples{
\donttest{
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2)
regns <- estimateRegns(sts_estimate, ~treatment*pid_rep, out)
printRegnTables(x = regns)
}
}
