#' Coefficient method for objects of class VLSTAR
#'
#' Returns the coefficients of a VLSTAR model for objects generated by \command{VLSTAR()}
#' @param object An object of class \sQuote{\code{VLSTAR}}; generated by \command{VLSTAR()}.
#' @param \dots Currently not used.
#' @aliases coef coefficients
#' @references Terasvirta T. and Yang Y. (2014), Specification, Estimation and Evaluation of Vector Smooth Transition
#'  Autoregressive Models with Applications. \emph{CREATES Research Paper 2014-8}
#' @author Andrea Bucci
#' @export
#' @keywords VLSTAR
#' @examples
#' mean(1:3)




coef.VLSTAR <-
  function(object, ...){
    ## export results
    coefs<-as.list(as.data.frame(object$Bhat))
    gamma = object$Gammac[,1]
    c = object$Gammac[,2]
    names(coefs) <- colnames(object$yoriginal)
    coeftoprint = list(coefs, gamma, c)
    names(coeftoprint) = c('coefficients', 'gamma', 'c')
    return(coefs)
  }
