% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_plot.R
\name{index_plot}
\alias{index_plot}
\title{Plot multidimensional cognitive test scores}
\usage{
index_plot(
  ds,
  id = "id",
  sub_plot = "_is",
  scores = c("_is", "_lo", "_up", "_per"),
  dom_names = c("immediate", "visuospatial", "verbal", "attention", "delayed", "total"),
  facet.by = NULL
)
}
\arguments{
\item{ds}{complete data frame}

\item{id}{colname of id column. Base for colouring}

\item{sub_plot}{main outcome scores variable to plot}

\item{scores}{variables to subset for plotting. Has to follow standard
naming (is to be changed)}

\item{dom_names}{domain names for axis naming}

\item{facet.by}{variable to base facet_grid on}
}
\value{
ggplot element
}
\description{
Plot index scores from five dimensional cognitive testing.
Includes option to facet.
}
\examples{
index_plot(stRoke::score[score$event=="A",])
}
