% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.HeckmanSK.R
\name{summary.HeckmanSK}
\alias{summary.HeckmanSK}
\title{Summary of Skew-Normal Heckman Model}
\usage{
\method{summary}{HeckmanSK}(object, ...)
}
\arguments{
\item{object}{An object of class \code{HeckmanSK}, containing the
fitted model results.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Prints to the console:
\itemize{
  \item Model fit statistics (log-likelihood, AIC, BIC, number of observations).
  \item Coefficient tables with standard errors and significance stars.
}
Invisibly returns \code{NULL}.
}
\description{
Prints a detailed summary of the parameter estimates and model fit
statistics for an object of class \code{HeckmanSK}.
}
\details{
This method displays the maximum likelihood estimation results
for the Heckman sample selection model with Skew-Normal errors.
It includes separate coefficient tables for:
\itemize{
  \item Selection equation (Probit model),
  \item Outcome equation,
  \item Error terms (\code{sigma}, \code{rho}, and \code{lambda}).
}
Additionally, it reports model fit statistics such as the log-likelihood,
AIC, BIC, and the number of observations.
}
\examples{
\dontrun{
data(Mroz87)
attach(Mroz87)
selectEq <- lfp ~ huswage + kids5 + mtr + fatheduc + educ + city
outcomeEq <- log(wage) ~ educ + city
model <- HeckmanSK(selectEq, outcomeEq, data = Mroz87, lambda = -1.5)
summary(model)
}

}
\seealso{
\code{\link{HeckmanSK}}
}
