% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{summary.PCAloc}
\alias{summary.PCAloc}
\title{Summary method for PCAloc}
\usage{
\method{summary}{PCAloc}(object, ...)
}
\arguments{
\item{object}{object of class PCAloc}

\item{...}{other input variables.}
}
\value{
Summary for PCAloc
}
\description{
Summary method for PCAloc
}
\examples{
#'
C1 = diag(c(1.1, 0.9, 0.6))
C2 = matrix(c(1.1, 0.1, -0.1,
              0.1, 1.0, -0.2,
             -0.1, -0.2, 0.7), ncol = 3)
C3 = (C1 + C2)/2

pca = sparsePCAloc(eta = 1, gamma = 0.5, cor = FALSE, COVS = list(C1, C2, C3),
             n_max = 100, increase_rho = list(FALSE, 100, 1), trace = FALSE)

summary(pca)
}
\seealso{
\code{\link[ssMRCD]{sparsePCAloc}}
}
