% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_helpers.R
\name{rescale_weights}
\alias{rescale_weights}
\title{Rescale Weight Matrix}
\usage{
rescale_weights(W)
}
\arguments{
\item{W}{weight matrix with diagonals equal to zero and at least one positive entry per row.}
}
\value{
An appropriately scaled weight matrix.
}
\description{
Given a matrix with values for neighborhood influences the function rescales
the matrix in order to get an appropriate weight matrix used for the function \code{\link[ssMRCD]{ssMRCD}}.
}
\examples{

W = matrix(c(0, 1, 2,
             1, 0, 1,
             2, 1, 0), nrow = 3)
rescale_weights(W)

}
\seealso{
\code{\link[ssMRCD]{ssMRCD}, \link[ssMRCD]{local_outliers_ssMRCD}, \link[ssMRCD]{geo_weights}}
}
