% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_summary.R
\name{panel_summary}
\alias{panel_summary}
\title{Summary Characteristics of a Revisit Panel Design}
\usage{
panel_summary(paneldsgn, visitdsgn = NULL)
}
\arguments{
\item{paneldsgn}{Two-dimensional array with dimnames specifying revisit
panel design. Typically, array is output from revisit_dsgn, revisit_bibd or
revisit_rand functions.}

\item{visitdsgn}{Two-dimensional array with same dimensions as paneldsgn
specifying the number of times a sample unit is sampled at each time
period. Default is visitdsgn=NULL, where default assumes that a sample unit
will be sampled only once at each time period.}
}
\value{
List of six elements.
  \itemize{ \item n.panel - number of panels in revisit design

  \item n.period - number of time periods in revisit design

  \item n.total - total number of sample events across all panels and all
  time periods, accounting for visitdsgn, that will be sampled in the revisit
  design

  \item n.periodunit - Vector of the number of time periods a unit will be
  sampled in each panel

  \item n.unitpnl - Vector of the number of sample units, accounting for
  visitdsgn, that will be sampled in each panel

  \item n.unitperiod - Vector of the number of sample units, accounting for
  visitdsgn, that will be sampled during each time period

  \item ncum.unit - Vector of the cumulative number of unique units that will
  be sampled in time periods up to and including the current time period.
  }
}
\description{
Revisit panel design characteristics are summarized: number of panels, number
of time periods, total number of sample events for the revisit design, total
number of sample events for each panel, total number of sample events for
each time period and cumulative number of unique units sampled by time
periods.
}
\details{
The revisit panel design and the visit design (if present) are
  summarized. Summaries can be useful to know the effort required to complete
  the survey design. See the values returned for the summaries that are
  produced.
}
\examples{
# Serially alternating panel revisit design summary
sa.dsgn <- revisit_dsgn(20, panels=list(SA60N=list(n=60, pnl_dsgn = c(1, 4),
                        pnl_n=NA, start_option="None")), begin=1 )
panel_summary(sa.dsgn)

# Add visit design where first panel is sampled twice at every time period
sa.visit <- sa.dsgn
sa.visit [sa.visit > 0] <- 1
sa.visit [1, sa.visit[1,] > 0] <- 2
panel_summary(sa.dsgn, sa.visit)

}
\seealso{
\describe{
    \item{\code{\link{revisit_dsgn}}}{create a panel revisit design}
    \item{\code{\link{revisit_bibd}}}{create a balanced incomplete block
      panel revisit design}
    \item{\code{\link{revisit_rand}}}{create a revisit design with random
      assignment to panels and time periods}
    \item{\code{\link{power.dsgn}}}{power calculation for multiple panel
      designs}
    \item{\code{\link{cov.panel.dsgn}}}{covariance matrix for a panel design}
    \item{\code{\link{plot_powerpaneldesign}}}{plot power curves for panel
      designs}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
