% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localMinima.R
\name{localMinima}
\alias{localMinima}
\title{Determine thresholds from a density plot}
\usage{
localMinima(distobj)
}
\arguments{
\item{distobj}{A distance object (usually from \code{\link{dist.dna}}).}
}
\value{
An object of class `density', which is a list containing the values
calculated by \code{\link{density}}. The element \code{localMinima} has been
added, which contains the values of the local minima of the density plot.
}
\description{
This function determines possible thresholds from the distance matrix for an
alignment.
}
\details{
This function is based on the concept of the barcoding gap, where a dip in
the density of genetic distances indicates the transition between intra- and
inter-specific distances. Understanding your data is vital to correctly
interpreting the output of this function, but as a start, the first local
minimum is often a good place to start.

The value of this function is that it does not require prior knowledge of
species identity to get an indication of potential threshold values.
}
\examples{


data(anoteropsis)
anoDist <- ape::dist.dna(anoteropsis)

anoThresh <- localMinima(anoDist)
graphics::plot(anoThresh)
anoThresh$localMinima
#Often the first value is the one to go for:
anoThresh$localMinima[1]

}
\seealso{
\code{\link{dist.dna}}, \code{\link{density}}. %% ~~objects to See
Also as \code{\link{help}}, ~~~
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Barcoding}
