% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_extent.R
\name{buffer_extent}
\alias{buffer_extent}
\title{Whole grain buffers}
\usage{
buffer_extent(e1, e2)
}
\arguments{
\item{e1}{input \code{\link[raster]{extent}}}

\item{e2}{grain size}
}
\description{
Ensure a raster extent aligns to a clean divisor.
}
\details{
This function is used to generate extents that have tidy boundaries, 
i.e. extents that align to a clean whole number like "10000".

(We can't use the S4 group generic because raster has set that specifically for use with '+' and '-'.)
}
\examples{
library(raster)
buffer_extent(extent(0.1, 2.2, 0, 3), 2)

p <- par(xpd = NA) 
plot(lux)
plot(extent(lux), lty = 2, add = TRUE, col = "grey")
plot(buffer_extent(lux, 0.1), add = TRUE)
abline(v = c(5.7, 6.6), h = c(49.4, 50.2))
title("boundaries on clean alignment to 0.1")
par(p)
}
