% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEESAR.R
\name{GEESAR}
\alias{GEESAR}
\title{Generalized Estimating Equations with Spatial Autoregressive Components}
\source{
https://doi.org/10.48550/arXiv.2412.00945
}
\usage{
GEESAR(
  formula,
  family = gaussian(),
  weights = NULL,
  data,
  W,
  start = NULL,
  toler = 1e-04,
  maxit = 200,
  trace = FALSE
)
}
\arguments{
\item{formula}{A formula specifying the model structure (response ~ predictors).}

\item{family}{A description of the error distribution and link function. Default is `gaussian()`.}

\item{weights}{Optional vector of prior weights. Must be positive.}

\item{data}{A data frame containing the variables in the model.}

\item{W}{A spatial weights matrix defining the spatial dependence structure.}

\item{start}{Optional starting values for parameter estimation.}

\item{toler}{Convergence tolerance for iterative optimization. Default is `1e-05`.}

\item{maxit}{Maximum number of iterations for model fitting. Default is `50`.}

\item{trace}{Logical; if `TRUE`, prints iteration details. Default is `FALSE`.}
}
\value{
A list of class `"GEESAR"` containing:
\item{coefficients}{Estimated regression coefficients.}
\item{rho}{Estimated spatial autoregressive parameter.}
\item{fitted.values}{Predicted values from the model.}
\item{linear.predictors}{Linear predictor values (`X * beta`).}
\item{prior.weights}{Weights used in estimation.}
\item{y}{Observed response values.}
\item{formula}{Model formula.}
\item{call}{Function call used to fit the model.}
\item{data}{Data used in the model.}
\item{converged}{Logical indicating whether the algorithm converged.}
\item{logLik}{Quasi-log-likelihood of the fitted model.}
\item{deviance}{Residual deviance.}
\item{df.residual}{Residual degrees of freedom.}
\item{phi}{Dispersion parameter estimate.}
\item{CIC}{Corrected Information Criterion.}
\item{RJC}{Robust Jackknife Correction.}
}
\description{
`GEESAR` estimates generalized estimating equations (GEE) incorporating spatial autoregressive (SAR) components.  
It extends GEE models to account for spatial dependence in the response variable.
}
\details{
The function estimates a spatially autoregressive GEE model by iteratively updating the spatial dependence 
parameter (`rho`) and regression coefficients (`beta`). The estimation follows a quasi-likelihood approach 
using iterative weighted least squares (IWLS).  

The function supports common GLM families (`gaussian`, `binomial`, `poisson`, `Gamma`, `inverse.gaussian`) and 
their quasi-likelihood equivalents.
}
\examples{
\donttest{
library(spdep)
library(sp)
data(meuse)
sp::coordinates(meuse) <- ~x+y
W <- spdep::nb2mat(knn2nb(knearneigh(meuse, k=5)), style="W")
fit <- GEESAR(cadmium ~ dist + elev, family=poisson(), data=meuse, W=W)
summary_SAR(fit)
}
}
\references{
Cruz, N. A., Toloza-Delgado, J. D., & Melo, O. O. (2024). 
Generalized spatial autoregressive model. arXiv preprint arXiv:2412.00945.
}
\seealso{
\code{\link{glm}}, \code{\link[gee]{gee}}, \code{\link[spdep]{spdep}}
}
