% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_sampling_netlogo.R
\name{lhc_generate_lhc_sample_netlogo}
\alias{lhc_generate_lhc_sample_netlogo}
\title{Prepares Netlogo experiment files for a sampling-based sensitivity analysis, using latin-hypercube sampling}
\usage{
lhc_generate_lhc_sample_netlogo(FILEPATH, PARAMETERS, PARAMVALS,
  NUMSAMPLES, ALGORITHM, EXPERIMENT_REPETITIONS, RUN_METRICS_EVERYSTEP,
  NETLOGO_SETUP_FUNCTION, NETLOGO_RUN_FUNCTION, MEASURES)
}
\arguments{
\item{FILEPATH}{Directory where the parameter samples are to be stored}

\item{PARAMETERS}{Array containing the names of the parameters of which parameter samples will be generated}

\item{PARAMVALS}{Array containing either the parameter value (if not of
interest in the analysis), or range under which this is being explored
(stated as as string e.g. "[5,50]" for a range of 5-50.}

\item{NUMSAMPLES}{The number of parameter subsets to be generated in the LHC design}

\item{ALGORITHM}{Choice of algorithm to use to generate the hypercube. Can be set to either 'normal' or 'optimum'. Beware optimum can take a long time to generate an optimised parameter set (more than 24 hours in some circumstances).}

\item{EXPERIMENT_REPETITIONS}{The number of times Netlogo should repeat the experiment for each set of parameter values.}

\item{RUN_METRICS_EVERYSTEP}{Boolean stating whether Netlogo should produce output for each timestep.}

\item{NETLOGO_SETUP_FUNCTION}{The name of the function in Netlogo that sets up the simulation. Commonly is named setup.}

\item{NETLOGO_RUN_FUNCTION}{The name of the function in Netlogo that starts the simulation. Commonly named go.}

\item{MEASURES}{Array containing the names of the Netlogo output measures which are used to analyse the simulation.}
}
\description{
This generates a specified number of simulation parameters sets using
latin-hypercube sampling. These are then processed into Netlogo XML
experiment files, one for each set of parameters.
}
