% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_analysis.R
\name{efast_generate_medians_for_all_parameter_subsets}
\alias{efast_generate_medians_for_all_parameter_subsets}
\title{Generates summary file for stochastic simulations stored in multiple files}
\usage{
efast_generate_medians_for_all_parameter_subsets(FILEPATH, NUMCURVES,
  PARAMETERS, NUMSAMPLES, NUMRUNSPERSAMPLE, MEASURES, RESULTFILENAME,
  ALTERNATIVEFILENAME, OUTPUTCOLSTART, OUTPUTCOLEND, TIMEPOINTS = NULL,
  TIMEPOINTSCALE = NULL, check_done = FALSE, current_time = NULL)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs can be found, in folders
or in CSV file format}

\item{NUMCURVES}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{NUMSAMPLES}{The number of parameter subsets that were generated in
the eFAST design}

\item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter
subset. This figure can be generated through Aleatory Analysis}

\item{MEASURES}{Array containing the names of the output measures which
are used to analyse the simulation}

\item{RESULTFILENAME}{{Name of the simulation results file. In the current
version, XML and CSV files can be processed. If performing this analysis
over multiple timepoints, it is assumed that the timepoint follows the
file name, e.g. trackedCells_Close_12.csv.}}

\item{ALTERNATIVEFILENAME}{In some cases, it may be relevant to read from
a further results file if the initial file contains no results. This
filename is set here. In the current version, XML and CSV files can be
processed.}

\item{OUTPUTCOLSTART}{Column number in the simulation results file where
output begins - saves (a) reading in unnecessary data, and (b) errors
where the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTCOLEND}{Column number in the simulation results file where the
last output measure is. Only required if running the first method.}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this
should be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Sets the scale of the timepoints being analysed,
e.g. "Hours"}

\item{check_done}{If multiple timepoints, whether the input has been checked}

\item{current_time}{If multiple timepoints, the current timepoint being processed}
}
\description{
Only to be applied in cases where simulation responses are supplied in the
folder structure shown in the R Journal paper, useful for cases where the
simulation is agent-based. Iterates through the folder structure
analysing the result of each replicate run under the same parameter
conditions, creating a CSV file for each curve/parameter pair. This will
hold the parameters of the run and the median of each simulation response
for that run. As stated earlier, more than one run result can exist in this
file. Where a simulation is being analysed for multiple timepoints,
this will iterate through the results at all timepoints, creating
curve/parameter pair CSV files for all specified timepoints.
}
