% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_double.R
\name{sparse_double}
\alias{sparse_double}
\title{Create sparse double vector}
\usage{
sparse_double(values, positions, length, default = 0)
}
\arguments{
\item{values}{double vector, values of non-zero entries.}

\item{positions}{integer vector, indices of non-zero entries.}

\item{length}{integer value, Length of vector.}

\item{default}{double value, value at indices not specified by \code{positions}.
Defaults to \code{0}. Cannot be \code{NA}.}
}
\value{
sparse double vector
}
\description{
Construction of vectors where only values and positions are recorded. The
Length and default values determine all other information.
}
\details{
\code{values} and \code{positions} are expected to be the same length, and are allowed
to both have zero length.

Allowed values for \code{value} is double and integer values. integer values will
be coerced to doubles. Missing values such as \code{NA} and \code{NA_real_} are
allowed. Everything else is disallowed, This includes \code{Inf} and \code{NaN}. The
values are also not allowed to take the same value as \code{default}.

\code{positions} should be integers or integer-like doubles. Everything else is
not allowed. Positions should furthermore be positive (\code{0} not allowed),
unique, and in increasing order. Lastly they should all be smaller that
\code{length}.

For developers:

setting \code{options("sparsevctrs.verbose_materialize" = TRUE)} will print a
message each time a sparse vector has been forced to materialize.
}
\examples{
sparse_double(numeric(), integer(), 10)

sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 10)

str(
  sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 1000000000)
)
}
\seealso{
\code{\link[=sparse_integer]{sparse_integer()}} \code{\link[=sparse_character]{sparse_character()}}
}
