% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_lsh_utils.R
\name{ft_lsh_utils}
\alias{ft_lsh_utils}
\alias{ml_approx_nearest_neighbors}
\alias{ml_approx_similarity_join}
\title{Utility functions for LSH models}
\usage{
ml_approx_nearest_neighbors(
  model,
  dataset,
  key,
  num_nearest_neighbors,
  dist_col = "distCol"
)

ml_approx_similarity_join(
  model,
  dataset_a,
  dataset_b,
  threshold,
  dist_col = "distCol"
)
}
\arguments{
\item{model}{A fitted LSH model, returned by either \code{ft_minhash_lsh()}
or \code{ft_bucketed_random_projection_lsh()}.}

\item{dataset}{The dataset to search for nearest neighbors of the key.}

\item{key}{Feature vector representing the item to search for.}

\item{num_nearest_neighbors}{The maximum number of nearest neighbors.}

\item{dist_col}{Output column for storing the distance between each result row and the key.}

\item{dataset_a}{One of the datasets to join.}

\item{dataset_b}{Another dataset to join.}

\item{threshold}{The threshold for the distance of row pairs.}
}
\description{
Utility functions for LSH models
}
