/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.DateFormat;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import sparklyr.Collectors$;
import sparklyr.Logger;
import sparklyr.Numeric;
import sparklyr.RUtils$;
import sparklyr.RUtils$$anonfun$arrayColumnWriter$1$;
import sparklyr.RawSXP;
import sparklyr.Serializer$;
import sparklyr.StructTypeAsJSON$;

public final class RUtils$ {
    public static final RUtils$ MODULE$;
    private final char XDR_FORMAT;
    public final int sparklyr$RUtils$$CHARSXP;
    public final int sparklyr$RUtils$$LGLSXP;
    public final int sparklyr$RUtils$$INTSXP;
    public final int sparklyr$RUtils$$REALSXP;
    public final int sparklyr$RUtils$$STRSXP;
    public final int sparklyr$RUtils$$VECSXP;
    public final int sparklyr$RUtils$$RAWSXP;
    public final int sparklyr$RUtils$$NILVALUE_SXP;
    public final int sparklyr$RUtils$$NA_INTEGER;

    static {
        new RUtils$();
    }

    public void validateSerializationFormat(DataInputStream dis, boolean verbose) {
        char format = Serializer$.MODULE$.readObjectType(dis);
        dis.readByte();
        if (this.XDR_FORMAT != format) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported R serialization format '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)format)})));
        }
        int version = Serializer$.MODULE$.readInt(dis);
        int writerVersion = Serializer$.MODULE$.readInt(dis);
        int minReaderVersion = Serializer$.MODULE$.readInt(dis);
        if (version != 2) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported R serialization version '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
        }
        if (verbose) {
            Logger logger = new Logger("Utils", 0);
            logger.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            logger.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R serialization writer version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)writerVersion)})));
            logger.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R serialization min reader version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)minReaderVersion)})));
        }
    }

    public boolean validateSerializationFormat$default$2() {
        return false;
    }

    public Object[] unserializeColumn(DataInputStream dis) {
        Logger logger = new Logger("RUtils", 0);
        int dtype = this.sparklyr$RUtils$$readDataType(dis);
        if (this.sparklyr$RUtils$$VECSXP != dtype) {
            logger.logWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected column data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dtype)})));
        }
        long num_rows = this.sparklyr$RUtils$$readLength(dis);
        Predef$ predef$ = Predef$.MODULE$;
        return (Object[])((TraversableOnce)new RichLong(0L).until((Object)BoxesRunTime.boxToLong((long)num_rows)).map((Function1)new Serializable(dis, logger){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dis$1;
            private final Logger logger$1;

            public final Object apply(long r) {
                int elem_dtype;
                block14: {
                    RawSXP rawSXP;
                    block8: {
                        Comparable<Boolean> comparable;
                        block11: {
                            String string;
                            int strlen;
                            block13: {
                                block12: {
                                    block10: {
                                        long num_elems;
                                        block9: {
                                            block7: {
                                                elem_dtype = RUtils$.MODULE$.sparklyr$RUtils$$readDataType(this.dis$1);
                                                if (RUtils$.MODULE$.sparklyr$RUtils$$NILVALUE_SXP != elem_dtype) break block7;
                                                rawSXP = null;
                                                break block8;
                                            }
                                            num_elems = RUtils$.MODULE$.sparklyr$RUtils$$readLength(this.dis$1);
                                            if (RUtils$.MODULE$.sparklyr$RUtils$$RAWSXP != elem_dtype) break block9;
                                            byte[] bytes = new byte[Predef$.MODULE$.long2Long(num_elems).intValue()];
                                            this.dis$1.readFully(bytes);
                                            rawSXP = new RawSXP(bytes);
                                            break block8;
                                        }
                                        if (1L != num_elems) {
                                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected number of elements: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)num_elems)})));
                                        }
                                        if (RUtils$.MODULE$.sparklyr$RUtils$$LGLSXP != elem_dtype) break block10;
                                        int v = Serializer$.MODULE$.readInt(this.dis$1);
                                        comparable = RUtils$.MODULE$.sparklyr$RUtils$$NA_INTEGER == v ? null : BoxesRunTime.boxToBoolean((v != 0 ? 1 : 0) != 0);
                                        break block11;
                                    }
                                    if (RUtils$.MODULE$.sparklyr$RUtils$$INTSXP != elem_dtype) break block12;
                                    int v = Serializer$.MODULE$.readInt(this.dis$1);
                                    comparable = RUtils$.MODULE$.sparklyr$RUtils$$NA_INTEGER == v ? null : BoxesRunTime.boxToInteger((int)v);
                                    break block11;
                                }
                                if (RUtils$.MODULE$.sparklyr$RUtils$$REALSXP != elem_dtype) break block13;
                                byte[] bytes = new byte[8];
                                this.dis$1.readFully(bytes);
                                long hw = (long)RUtils$.MODULE$.sparklyr$RUtils$$extractInt(bytes, 0) & 0xFFFFFFFFL;
                                long lw = (long)RUtils$.MODULE$.sparklyr$RUtils$$extractInt(bytes, 4) & 0xFFFFFFFFL;
                                comparable = hw == 0x7FF00000L && lw == 1954L ? null : BoxesRunTime.boxToDouble((double)Double.longBitsToDouble(hw << 32 | lw));
                                break block11;
                            }
                            if (RUtils$.MODULE$.sparklyr$RUtils$$STRSXP != elem_dtype) break block14;
                            int ctype = RUtils$.MODULE$.sparklyr$RUtils$$readDataType(this.dis$1);
                            if (RUtils$.MODULE$.sparklyr$RUtils$$CHARSXP != ctype) {
                                this.logger$1.logWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected character type ", " found in string expression"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctype)})));
                            }
                            if (-1L == (long)(strlen = Serializer$.MODULE$.readInt(this.dis$1))) {
                                string = null;
                            } else {
                                byte[] bytes = new byte[Predef$.MODULE$.int2Integer(strlen).intValue()];
                                this.dis$1.readFully(bytes);
                                string = new String(bytes, StandardCharsets.UTF_8);
                            }
                            comparable = string;
                        }
                        rawSXP = comparable;
                    }
                    return rawSXP;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)elem_dtype)})));
            }
            {
                this.dis$1 = dis$1;
                this.logger$1 = logger$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
    }

    private int[] unserializeIntColumn(DataInputStream dis) {
        return (int[])Array$.MODULE$.fill(5, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return 0;
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Int());
    }

    private String[] unserializeStringColumn(DataInputStream dis) {
        return (String[])Array$.MODULE$.fill(5, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public int sparklyr$RUtils$$readDataType(DataInputStream dis) {
        return Serializer$.MODULE$.readInt(dis) & 0xFF;
    }

    public long sparklyr$RUtils$$readLength(DataInputStream dis) {
        int x = Serializer$.MODULE$.readInt(dis);
        if (-1 == x) {
            throw new IllegalArgumentException("Vector with length greater than INT_MAX (i.e., 'LONG_VECTOR') is not supported yet");
        }
        if (x < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Negative serialized vector length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})));
        }
        return x;
    }

    public int sparklyr$RUtils$$extractInt(byte[] bytes, int offset) {
        Predef$ predef$ = Predef$.MODULE$;
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(0, 4).map((Function1)new Serializable(bytes, offset){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;
            private final int offset$1;

            public final int apply(int i) {
                return this.apply$mcII$sp(i);
            }

            public int apply$mcII$sp(int i) {
                return (Predef$.MODULE$.byte2Byte(this.bytes$1[this.offset$1 + i]).intValue() & 0xFF) << 24 - i * 8;
            }
            {
                this.bytes$1 = bytes$1;
                this.offset$1 = offset$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int p, int q) {
                return p | q;
            }

            public int apply$mcIII$sp(int p, int q) {
                return p | q;
            }
        }));
    }

    private int rVersion(int v, int p, int s) {
        return v * 65536 + p * 256 + s;
    }

    public void writeXdrHeader(DataOutputStream dos) {
        dos.writeByte(this.XDR_FORMAT);
        dos.writeByte(10);
        dos.writeInt(2);
        dos.writeInt(this.rVersion(1, 4, 0));
        dos.writeInt(this.rVersion(1, 4, 0));
    }

    public void writeDataFrameHeader(DataOutputStream dos, Seq<Tuple2<String, String>> dtypes) {
        this.sparklyr$RUtils$$writeFlags(dos, this.sparklyr$RUtils$$VECSXP, this.sparklyr$RUtils$$writeFlags$default$3(), this.sparklyr$RUtils$$writeFlags$default$4(), this.sparklyr$RUtils$$writeFlags$default$5(), this.sparklyr$RUtils$$writeFlags$default$6());
        this.sparklyr$RUtils$$writeLength(dos, 5);
        this.writeStringValues(dos, (Seq<String>)((Seq)dtypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x) {
                return (String)x._1();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        ListBuffer timestampColIdxes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer dateColIdxes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer structColIdxes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$ predef$ = Predef$.MODULE$;
        RichInt$.MODULE$.to$extension0(1, dtypes.length()).map((Function1)new Serializable(dtypes, timestampColIdxes, dateColIdxes, structColIdxes){
            public static final long serialVersionUID = 0L;
            private final Seq dtypes$1;
            private final ListBuffer timestampColIdxes$1;
            private final ListBuffer dateColIdxes$1;
            private final ListBuffer structColIdxes$1;

            public final Object apply(int idx) {
                Object object;
                String colType = (String)((Tuple2)this.dtypes$1.apply(idx - 1))._2();
                if (!("TimestampType" != null ? !"TimestampType".equals(colType) : colType != null)) {
                    object = this.timestampColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                } else if (!("DateType" != null ? !"DateType".equals(colType) : colType != null)) {
                    object = this.dateColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                } else {
                    Option option = Collectors$.MODULE$.ReTimestampArrayType().unapplySeq((Object)colType);
                    if (option.isEmpty()) {
                        Option option2 = Collectors$.MODULE$.ReDateArrayType().unapplySeq((Object)colType);
                        if (option2.isEmpty()) {
                            String string = StructTypeAsJSON$.MODULE$.DType();
                            object = !(string != null ? !string.equals(colType) : colType != null) ? this.structColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx)) : BoxedUnit.UNIT;
                        } else {
                            object = this.dateColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                        }
                    } else {
                        object = this.timestampColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                    }
                }
                return object;
            }
            {
                this.dtypes$1 = dtypes$1;
                this.timestampColIdxes$1 = timestampColIdxes$1;
                this.dateColIdxes$1 = dateColIdxes$1;
                this.structColIdxes$1 = structColIdxes$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.writeIntValues(dos, (Seq<Object>)timestampColIdxes);
        this.writeIntValues(dos, (Seq<Object>)dateColIdxes);
        this.writeIntValues(dos, (Seq<Object>)structColIdxes);
        this.sparklyr$RUtils$$writeFlags(dos, this.sparklyr$RUtils$$VECSXP, this.sparklyr$RUtils$$writeFlags$default$3(), this.sparklyr$RUtils$$writeFlags$default$4(), this.sparklyr$RUtils$$writeFlags$default$5(), this.sparklyr$RUtils$$writeFlags$default$6());
        this.sparklyr$RUtils$$writeLength(dos, dtypes.length());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeColumn(DataOutputStream dos, int numRows, Iterator<Row> colIter, String dtype) {
        void var29_28;
        if (!("BooleanType" != null ? !"BooleanType".equals(dtype) : dtype != null)) {
            Serializable serializable = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                    RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$LGLSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                    RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                    colIter.foreach((Function1)new Serializable(this, dos){
                        public static final long serialVersionUID = 0L;
                        private final DataOutputStream dos$3;

                        public final void apply(Row row) {
                            RUtils$.MODULE$.sparklyr$RUtils$$writeLglValue(this.dos$3, row.get(0));
                        }
                        {
                            this.dos$3 = dos$3;
                        }
                    });
                }
            };
        } else if (!("ByteType" != null ? !"ByteType".equals(dtype) : dtype != null)) {
            Numeric.ByteIsIntegral$ byteIsIntegral$ = Numeric.ByteIsIntegral$.MODULE$;
            Serializable serializable = new Serializable((Integral)byteIsIntegral$){
                public static final long serialVersionUID = 0L;
                public final Integral evidence$1$1;

                public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                    RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$INTSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                    RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                    colIter.foreach((Function1)new Serializable(this, dos){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.integralColumnWriter.1 $outer;
                        private final DataOutputStream dos$4;

                        public final void apply(Row row) {
                            RUtils$.MODULE$.sparklyr$RUtils$$writeIntegralValue(this.dos$4, row.get(0), this.$outer.evidence$1$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dos$4 = dos$4;
                        }
                    });
                }
                {
                    this.evidence$1$1 = evidence$1$1;
                }
            };
        } else if (!("ShortType" != null ? !"ShortType".equals(dtype) : dtype != null)) {
            Numeric.ShortIsIntegral$ shortIsIntegral$ = Numeric.ShortIsIntegral$.MODULE$;
            Serializable serializable = new /* invalid duplicate definition of identical inner class */;
        } else if (!("IntegerType" != null ? !"IntegerType".equals(dtype) : dtype != null)) {
            Numeric.IntIsIntegral$ intIsIntegral$ = Numeric.IntIsIntegral$.MODULE$;
            Serializable serializable = new /* invalid duplicate definition of identical inner class */;
        } else if (!("FloatType" != null ? !"FloatType".equals(dtype) : dtype != null)) {
            Numeric.FloatIsFractional$ floatIsFractional$ = Numeric.FloatIsFractional$.MODULE$;
            Serializable serializable = new Serializable((scala.math.Numeric)floatIsFractional$){
                public static final long serialVersionUID = 0L;
                public final scala.math.Numeric evidence$3$1;

                public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                    RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$REALSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                    RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                    colIter.foreach((Function1)new Serializable(this, dos){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.numericColumnWriter.1 $outer;
                        private final DataOutputStream dos$5;

                        public final void apply(Row row) {
                            RUtils$.MODULE$.sparklyr$RUtils$$writeNumericValue(this.dos$5, row.get(0), this.$outer.evidence$3$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dos$5 = dos$5;
                        }
                    });
                }
                {
                    this.evidence$3$1 = evidence$3$1;
                }
            };
        } else if (!("LongType" != null ? !"LongType".equals(dtype) : dtype != null)) {
            Numeric.LongIsIntegral$ longIsIntegral$ = Numeric.LongIsIntegral$.MODULE$;
            Serializable serializable = new /* invalid duplicate definition of identical inner class */;
        } else if (!("DoubleType" != null ? !"DoubleType".equals(dtype) : dtype != null)) {
            Numeric.DoubleIsFractional$ doubleIsFractional$ = Numeric.DoubleIsFractional$.MODULE$;
            Serializable serializable = new /* invalid duplicate definition of identical inner class */;
        } else {
            Option option = Collectors$.MODULE$.ReDecimalType().unapplySeq((Object)dtype);
            if (option.isEmpty()) {
                if (!("StringType" != null ? !"StringType".equals(dtype) : dtype != null)) {
                    Serializable serializable = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                            RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$STRSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                            RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                            colIter.foreach((Function1)new Serializable(this, dos){
                                public static final long serialVersionUID = 0L;
                                private final DataOutputStream dos$7;

                                public final void apply(Row row) {
                                    RUtils$.MODULE$.sparklyr$RUtils$$writeStringValue(this.dos$7, row.get(0));
                                }
                                {
                                    this.dos$7 = dos$7;
                                }
                            });
                        }
                    };
                } else if (!("TimestampType" != null ? !"TimestampType".equals(dtype) : dtype != null)) {
                    Serializable serializable = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                            RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$REALSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                            RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                            colIter.foreach((Function1)new Serializable(this, dos){
                                public static final long serialVersionUID = 0L;
                                private final DataOutputStream dos$8;

                                public final void apply(Row row) {
                                    RUtils$.MODULE$.sparklyr$RUtils$$writeTimestampValue(this.dos$8, row.get(0));
                                }
                                {
                                    this.dos$8 = dos$8;
                                }
                            });
                        }
                    };
                } else if (!("DateType" != null ? !"DateType".equals(dtype) : dtype != null)) {
                    Serializable serializable = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                            RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$STRSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                            RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                            colIter.foreach((Function1)new Serializable(this, dos){
                                public static final long serialVersionUID = 0L;
                                private final DataOutputStream dos$9;

                                public final void apply(Row row) {
                                    RUtils$.MODULE$.sparklyr$RUtils$$writeDateValue(this.dos$9, row.get(0));
                                }
                                {
                                    this.dos$9 = dos$9;
                                }
                            });
                        }
                    };
                } else {
                    Option option2 = Collectors$.MODULE$.ReBooleanArrayType().unapplySeq((Object)dtype);
                    if (option2.isEmpty()) {
                        Option option3 = Collectors$.MODULE$.ReByteArrayType().unapplySeq((Object)dtype);
                        if (option3.isEmpty()) {
                            Option option4 = Collectors$.MODULE$.ReShortArrayType().unapplySeq((Object)dtype);
                            if (option4.isEmpty()) {
                                Option option5 = Collectors$.MODULE$.ReIntegerArrayType().unapplySeq((Object)dtype);
                                if (option5.isEmpty()) {
                                    Option option6 = Collectors$.MODULE$.ReLongArrayType().unapplySeq((Object)dtype);
                                    if (option6.isEmpty()) {
                                        Option option7 = Collectors$.MODULE$.ReDecimalArrayType().unapplySeq((Object)dtype);
                                        if (option7.isEmpty()) {
                                            Option option8 = Collectors$.MODULE$.ReFloatArrayType().unapplySeq((Object)dtype);
                                            if (option8.isEmpty()) {
                                                Option option9 = Collectors$.MODULE$.ReDoubleArrayType().unapplySeq((Object)dtype);
                                                if (option9.isEmpty()) {
                                                    Option option10 = Collectors$.MODULE$.ReStringArrayType().unapplySeq((Object)dtype);
                                                    if (option10.isEmpty()) {
                                                        Option option11 = Collectors$.MODULE$.ReTimestampArrayType().unapplySeq((Object)dtype);
                                                        if (option11.isEmpty()) {
                                                            Option option12 = Collectors$.MODULE$.ReDateArrayType().unapplySeq((Object)dtype);
                                                            if (option12.isEmpty()) {
                                                                String string = StructTypeAsJSON$.MODULE$.DType();
                                                                if (string != null ? !string.equals(dtype) : dtype != null) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Serializing Spark dataframe column of type '", "' to RDS is unsupported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dtype})));
                                                                Serializable serializable = new /* invalid duplicate definition of identical inner class */;
                                                            } else {
                                                                Serializable serializable = new Serializable(){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final void apply(DataOutputStream dos, Object v) {
                                                                        RUtils$.MODULE$.sparklyr$RUtils$$writeDateValue(dos, v);
                                                                    }
                                                                };
                                                                int n = this.sparklyr$RUtils$$STRSXP;
                                                                Serializable serializable2 = new Serializable(n, (Function2)serializable){
                                                                    public static final long serialVersionUID = 0L;
                                                                    public final int elemType$1;
                                                                    public final Function2 elemWriter$1;

                                                                    public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                                                                        RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$VECSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                                                                        RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                                                                        colIter.foreach((Function1)new Serializable(this, dos){
                                                                            public static final long serialVersionUID = 0L;
                                                                            public final /* synthetic */ anonfun.arrayColumnWriter.1 $outer;
                                                                            public final DataOutputStream dos$10;

                                                                            public final Object apply(Row row) {
                                                                                Object object;
                                                                                Object v = row.get(0);
                                                                                if (v == null) {
                                                                                    RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(this.dos$10, RUtils$.MODULE$.sparklyr$RUtils$$NILVALUE_SXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                                                                                    object = BoxedUnit.UNIT;
                                                                                } else {
                                                                                    WrappedArray arr = (WrappedArray)v;
                                                                                    RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(this.dos$10, this.$outer.elemType$1, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                                                                                    RUtils$.MODULE$.sparklyr$RUtils$$writeLength(this.dos$10, arr.length());
                                                                                    object = arr.map((Function1)new Serializable(this){
                                                                                        public static final long serialVersionUID = 0L;
                                                                                        private final /* synthetic */ anonfun$arrayColumnWriter$1$$anonfun$apply$8 $outer;

                                                                                        public final void apply(Object b) {
                                                                                            this.$outer.$outer.elemWriter$1.apply((Object)this.$outer.dos$10, b);
                                                                                        }
                                                                                        {
                                                                                            if ($outer == null) {
                                                                                                throw new NullPointerException();
                                                                                            }
                                                                                            this.$outer = $outer;
                                                                                        }
                                                                                    }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                                                                                }
                                                                                return object;
                                                                            }

                                                                            public /* synthetic */ anonfun.arrayColumnWriter.1 sparklyr$RUtils$$anonfun$$anonfun$$$outer() {
                                                                                return this.$outer;
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw new NullPointerException();
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.dos$10 = dos$10;
                                                                            }
                                                                        });
                                                                    }
                                                                    {
                                                                        this.elemType$1 = elemType$1;
                                                                        this.elemWriter$1 = elemWriter$1;
                                                                    }
                                                                };
                                                            }
                                                        } else {
                                                            Serializable serializable = new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final void apply(DataOutputStream dos, Object v) {
                                                                    RUtils$.MODULE$.sparklyr$RUtils$$writeTimestampValue(dos, v);
                                                                }
                                                            };
                                                            int n = this.sparklyr$RUtils$$REALSXP;
                                                            Serializable serializable3 = new /* invalid duplicate definition of identical inner class */;
                                                        }
                                                    } else {
                                                        Serializable serializable = new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final void apply(DataOutputStream dos, Object v) {
                                                                RUtils$.MODULE$.sparklyr$RUtils$$writeStringValue(dos, v);
                                                            }
                                                        };
                                                        int n = this.sparklyr$RUtils$$STRSXP;
                                                        Serializable serializable4 = new /* invalid duplicate definition of identical inner class */;
                                                    }
                                                } else {
                                                    Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final void apply(DataOutputStream dos, Object v) {
                                                            RUtils$.MODULE$.sparklyr$RUtils$$writeNumericValue(dos, v, Numeric.DoubleIsFractional$.MODULE$);
                                                        }
                                                    });
                                                }
                                            } else {
                                                Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final void apply(DataOutputStream dos, Object v) {
                                                        RUtils$.MODULE$.sparklyr$RUtils$$writeNumericValue(dos, v, Numeric.FloatIsFractional$.MODULE$);
                                                    }
                                                });
                                            }
                                        } else {
                                            Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(DataOutputStream dos, Object v) {
                                                    RUtils$.MODULE$.sparklyr$RUtils$$writeDecimalValue(dos, v);
                                                }
                                            });
                                        }
                                    } else {
                                        Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final void apply(DataOutputStream dos, Object v) {
                                                RUtils$.MODULE$.sparklyr$RUtils$$writeNumericValue(dos, v, Numeric.LongIsIntegral$.MODULE$);
                                            }
                                        });
                                    }
                                } else {
                                    Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$INTSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(DataOutputStream dos, Object v) {
                                            RUtils$.MODULE$.sparklyr$RUtils$$writeIntegralValue(dos, v, Numeric.IntIsIntegral$.MODULE$);
                                        }
                                    });
                                }
                            } else {
                                Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$INTSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(DataOutputStream dos, Object v) {
                                        RUtils$.MODULE$.sparklyr$RUtils$$writeIntegralValue(dos, v, Numeric.ShortIsIntegral$.MODULE$);
                                    }
                                });
                            }
                        } else {
                            Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$INTSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(DataOutputStream dos, Object v) {
                                    RUtils$.MODULE$.sparklyr$RUtils$$writeIntegralValue(dos, v, Numeric.ByteIsIntegral$.MODULE$);
                                }
                            });
                        }
                    } else {
                        Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3 = this.arrayColumnWriter(this.sparklyr$RUtils$$LGLSXP, (Function2<DataOutputStream, Object, BoxedUnit>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(DataOutputStream dos, Object v) {
                                RUtils$.MODULE$.sparklyr$RUtils$$writeLglValue(dos, v);
                            }
                        });
                    }
                }
            } else {
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(DataOutputStream dos, int numRows, Iterator<Row> colIter) {
                        RUtils$.MODULE$.sparklyr$RUtils$$writeFlags(dos, RUtils$.MODULE$.sparklyr$RUtils$$REALSXP, RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$3(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$4(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$5(), RUtils$.MODULE$.sparklyr$RUtils$$writeFlags$default$6());
                        RUtils$.MODULE$.sparklyr$RUtils$$writeLength(dos, numRows);
                        colIter.foreach((Function1)new Serializable(this, dos){
                            public static final long serialVersionUID = 0L;
                            private final DataOutputStream dos$6;

                            public final void apply(Row row) {
                                RUtils$.MODULE$.sparklyr$RUtils$$writeDecimalValue(this.dos$6, row.get(0));
                            }
                            {
                                this.dos$6 = dos$6;
                            }
                        });
                    }
                };
            }
        }
        var29_28.apply((Object)dos, (Object)BoxesRunTime.boxToInteger((int)numRows), colIter);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> booleanColumnWriter() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void sparklyr$RUtils$$writeLglValue(DataOutputStream dos, Object v) {
        int n;
        if (v == null) {
            n = this.sparklyr$RUtils$$NA_INTEGER;
        } else {
            boolean b = BoxesRunTime.unboxToBoolean((Object)v);
            Predef$ predef$ = Predef$.MODULE$;
            n = new RichBoolean(b).compare((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        dos.writeInt(n);
    }

    private <SrcType> Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> integralColumnWriter(Integral<SrcType> evidence$1) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private void writeIntValues(DataOutputStream dos, Seq<Object> vals) {
        this.sparklyr$RUtils$$writeFlags(dos, this.sparklyr$RUtils$$INTSXP, this.sparklyr$RUtils$$writeFlags$default$3(), this.sparklyr$RUtils$$writeFlags$default$4(), this.sparklyr$RUtils$$writeFlags$default$5(), this.sparklyr$RUtils$$writeFlags$default$6());
        this.sparklyr$RUtils$$writeLength(dos, vals.length());
        vals.map((Function1)new Serializable(dos){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream dos$2;

            public final void apply(int x) {
                this.apply$mcVI$sp(x);
            }

            public void apply$mcVI$sp(int x) {
                RUtils$.MODULE$.sparklyr$RUtils$$writeIntegralValue(this.dos$2, BoxesRunTime.boxToInteger((int)x), Numeric.IntIsIntegral$.MODULE$);
            }
            {
                this.dos$2 = dos$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <SrcType> void sparklyr$RUtils$$writeIntegralValue(DataOutputStream dos, Object v, Integral<SrcType> evidence$2) {
        int n;
        if (v == null) {
            n = this.sparklyr$RUtils$$NA_INTEGER;
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            n = ((scala.math.Numeric)evidence$2).toInt(v);
        }
        dos.writeInt(n);
    }

    private <SrcType> Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> numericColumnWriter(scala.math.Numeric<SrcType> evidence$3) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public <SrcType> void sparklyr$RUtils$$writeNumericValue(DataOutputStream dos, Object v, scala.math.Numeric<SrcType> evidence$4) {
        None$ none$;
        if (v == null) {
            none$ = None$.MODULE$;
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)evidence$4.toDouble(v)));
        }
        Serializer$.MODULE$.writeNumeric(dos, new Numeric((Option<Object>)none$));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> decimalColumnWriter() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void sparklyr$RUtils$$writeDecimalValue(DataOutputStream dos, Object v) {
        None$ none$;
        if (v instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)v;
            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()));
        } else {
            none$ = None$.MODULE$;
        }
        Serializer$.MODULE$.writeNumeric(dos, new Numeric((Option<Object>)none$));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> stringColumnWriter() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> timestampColumnWriter() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void sparklyr$RUtils$$writeTimestampValue(DataOutputStream dos, Object v) {
        double d;
        if (v instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)v;
            d = Serializer$.MODULE$.timestampToSeconds(date);
        } else {
            d = Double.NaN;
        }
        dos.writeDouble(d);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> dateColumnWriter() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void sparklyr$RUtils$$writeDateValue(DataOutputStream dos, Object v) {
        String string;
        if (v instanceof Date) {
            Date date = (Date)v;
            string = ((DateFormat)Serializer$.MODULE$.dateFormat().get()).format(date);
        } else {
            string = "";
        }
        this.sparklyr$RUtils$$writeStringValue(dos, string);
    }

    private void writeStringValues(DataOutputStream dos, Seq<String> vals) {
        this.sparklyr$RUtils$$writeFlags(dos, this.sparklyr$RUtils$$STRSXP, this.sparklyr$RUtils$$writeFlags$default$3(), this.sparklyr$RUtils$$writeFlags$default$4(), this.sparklyr$RUtils$$writeFlags$default$5(), this.sparklyr$RUtils$$writeFlags$default$6());
        this.sparklyr$RUtils$$writeLength(dos, vals.length());
        vals.map((Function1)new Serializable(dos){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream dos$1;

            public final void apply(String x) {
                RUtils$.MODULE$.sparklyr$RUtils$$writeStringValue(this.dos$1, x);
            }
            {
                this.dos$1 = dos$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void sparklyr$RUtils$$writeStringValue(DataOutputStream dos, Object v) {
        this.sparklyr$RUtils$$writeFlags(dos, this.sparklyr$RUtils$$CHARSXP, this.sparklyr$RUtils$$writeFlags$default$3(), this.sparklyr$RUtils$$writeFlags$default$4(), this.sparklyr$RUtils$$writeFlags$default$5(), this.sparklyr$RUtils$$writeFlags$default$6());
        if (v instanceof String) {
            String string = (String)v;
            Serializer$.MODULE$.writeString(dos, string);
        } else {
            this.sparklyr$RUtils$$writeLength(dos, -1);
        }
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> arrayColumnWriter(int elemType, Function2<DataOutputStream, Object, BoxedUnit> elemWriter) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void sparklyr$RUtils$$writeFlags(DataOutputStream dos, int dtype, int levels, boolean isObj, boolean hasAttr, boolean hasTag) {
        Predef$ predef$ = Predef$.MODULE$;
        Predef$ predef$2 = Predef$.MODULE$;
        Predef$ predef$3 = Predef$.MODULE$;
        dos.writeInt(dtype & 0xFF | new RichBoolean(isObj).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)) << 8 | new RichBoolean(hasAttr).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)) << 9 | new RichBoolean(hasTag).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)) << 10 | levels << 12);
    }

    public int sparklyr$RUtils$$writeFlags$default$3() {
        return 0;
    }

    public boolean sparklyr$RUtils$$writeFlags$default$4() {
        return false;
    }

    public boolean sparklyr$RUtils$$writeFlags$default$5() {
        return false;
    }

    public boolean sparklyr$RUtils$$writeFlags$default$6() {
        return false;
    }

    public void sparklyr$RUtils$$writeLength(DataOutputStream dos, int length) {
        dos.writeInt(length);
    }

    private RUtils$() {
        MODULE$ = this;
        this.XDR_FORMAT = (char)88;
        this.sparklyr$RUtils$$CHARSXP = 9;
        this.sparklyr$RUtils$$LGLSXP = 10;
        this.sparklyr$RUtils$$INTSXP = 13;
        this.sparklyr$RUtils$$REALSXP = 14;
        this.sparklyr$RUtils$$STRSXP = 16;
        this.sparklyr$RUtils$$VECSXP = 19;
        this.sparklyr$RUtils$$RAWSXP = 24;
        this.sparklyr$RUtils$$NILVALUE_SXP = 254;
        this.sparklyr$RUtils$$NA_INTEGER = Integer.MIN_VALUE;
    }
}

