% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available-data-s3.R
\name{spod_available_data_s3}
\alias{spod_available_data_s3}
\title{Get available data list from Amazon S3 storage}
\usage{
spod_available_data_s3(
  ver = c(1, 2),
  force = FALSE,
  quiet = FALSE,
  data_dir = spod_get_data_dir()
)
}
\arguments{
\item{ver}{Integer. Can be 1 or 2. The version of the data to use. v1 spans 2020-2021, v2 covers 2022 and onwards. See more details in codebooks with \code{\link[=spod_codebook]{spod_codebook()}}.}

\item{force}{Logical. If \code{TRUE}, force re-download of metadata. For Amazon S3 this queries the S3 bucket for the XML file it re-downloads. If \code{FALSE}, only update the available data list if it is older than 1 day.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Default is \code{FALSE}.}

\item{data_dir}{The directory where the data is stored. Defaults to the value returned by \code{spod_get_data_dir()}.}
}
\value{
A tibble with links, release dates of files in the data, dates of data coverage, local paths to files, and the download status.
}
\description{
Get a table with links to available data files for the specified data version from Amazon S3 storage.
}
\keyword{internal}
