.ULI <- function(...) {
  redondGeo <- cbind(...) ## always a matrix
  if (ncol(redondGeo)==0L) return(rep(1L,nrow(redondGeo))) ## .generateInitPhi with constant predictor led here
  if (nrow(redondGeo)==1L) return(1L) ##  trivial case where the forllowingcode fails
  # redondFac <- apply(redondGeo,1,paste,collapse=" ") ## always characters whatever the number of columns 
  # redondFac <- as.integer(as.factor(redondFac)) ## as.factor effectively distinguishes unique character strings 
  # uniqueFac <- unique(redondFac) ## seems to preserve order ## unique(<integer>) has unambiguous behaviour
  # sapply(lapply(redondFac, `==`, uniqueFac ), which)
  redondFac <- apply(redondGeo,2L,factor,labels="") # not cute use of labels... 
  redondFac <- apply(redondFac,1L,paste,collapse=":") ## paste factors
  redondFac <- as.character(factor(redondFac))
  uniqueFac <- unique(redondFac) ## seems to preserve order ## unique(<integer>) has unambiguous behaviour
  uniqueIdx <- seq(length(uniqueFac))
  names(uniqueIdx) <- uniqueFac
  return(uniqueIdx[redondFac])
}

### Utilities for parsing the mixed model formula
## Functions more of less distantly derived from lme4 version of findbars

## Determine random-effects expressions from a formula

# different ! :
# findbars(~ 1 + (1|batch/cask))
# .findbarsMM(~ 1 + (1|batch/cask))


.findbarsMM <-  function (term) {
    if (is.name(term) || !is.language(term)) # eg y or 1 in y~1+... ?
      return(NULL)
    if (term[[1]] == as.name("(")) { ## may be (.|.) but also just anything in parenthesis in a formula
      res <- .findbarsMM(term[[2]])
      if (length(res)==1L) attr(res,"type") <- "(.|.)"
      return(res) 
    }
    if (!is.call(term)) 
      stop("term must be of class call")
    if (term[[1]] == as.name("|")) 
      return(term)
    if (length(term) == 2L) { ## 
      term1 <- as.character(term[[1]])
      if (term1 %in% c("adjacency","Matern","Cauchy","AR1","corrMatrix")) {
        res <- .findbarsMM(term[[2]]) ## term[[2]] is .|. and will match term[[1]] == as.name("|") , NOT term[[1]] == as.name("(")
        attr(res,"type") <- term1
        return(res) 
      } else return(.findbarsMM(term[[2]])) 
    }
    c(.findbarsMM(term[[2]]), .findbarsMM(term[[3]]))
  }


## Remove the random-effects terms from a mixed-effects formula
.stripRanefs <- function (term) { ## different from lme4::nobars
  nb <- .stripRanefs_(term)
  if (is(term, "formula") && length(term) == 3 && ! inherits(nb,"formula")) {
    nb <- as.formula(paste(deparse(nb),"~ 0")) ## apparently needed bc model.frame(...)) does not handle the formula  '~ 0' (?)
  }
  nb
}
  
.stripRanefs_ <- function (term) { ## compare to lme4:::nobars_
  if (!("|" %in% all.names(term))) 
    return(term)
  if (is.call(term) && term[[1]] == as.name("|")) 
    return(NULL)
  if (length(term) == 2) {
    nb <- .stripRanefs_(term[[2]])
    if (is.null(nb)) 
      return(NULL)
    term[[2]] <- nb
    return(term)
  }
  nb2 <- .stripRanefs_(term[[2]])
  nb3 <- .stripRanefs_(term[[3]])
  if (is.null(nb2)) 
    return(nb3)
  if (is.null(nb3)) 
    return(nb2)
  term[[2]] <- nb2
  term[[3]] <- nb3
  term
}

## lme4::subbars "Substitute the '+' function for the '|' function in a mixed-model formula, recursively (hence the argument name term). This provides a formula suitable for the current model.frame function."
## Small modif; origina lversion shows handling of '||'
.subbarsMM <- function (term) {   if (is.name(term) || !is.language(term)) 
    return(term)
  if (length(term) == 2) {
    term[[2]] <- .subbarsMM(term[[2]])
    return(term)
  }
  # stopifnot(length(term) >= 3) ## inefficient
  if (is.call(term) && term[[1]] == as.name("|")) 
    term[[1]] <- as.name("+")
  for (j in 2:length(term)) term[[j]] <- .subbarsMM(term[[j]])
  term
}



.stripOffset <- function (term) { 
  nb <- .stripOffset_(term)
  ## cf comment in nobarsMM
  if (is(term, "formula") && length(term) == 3  && ! inherits(nb,"formula")) {
    nb <- as.formula(paste(deparse(nb),"~ 0")) 
  }
  ## cf comment in nobarsMM
  # if (is.null(nb)) {
  #   nb <- if (is(term, "formula")) 
  #     ~0
  #   # else 0 ## would convert y~x+offset(...) into y~x+0 
  # }
  nb
}


.stripOffset_ <- function (term)   {
  if (!("offset" %in% all.names(term))) 
    return(term)
  if (length(term) == 2) { ## this is the case if this term is  offset(...)
    term1 <- as.character(term[[1]])
    if (term1=="offset") {
      return(NULL) 
    }  
    nb <- .stripOffset_(term[[2]])
    if (is.null(nb)) 
      return(NULL)
    term[[2]] <- nb
    return(term)
  }
  nb2 <- .stripOffset_(term[[2]])
  nb3 <- .stripOffset_(term[[3]])
  if (is.null(nb2)) {
    #if (inherits(term,"formula")) {   ## code for autonomous noOffset fn up to 07/2016
    #  return(as.formula(paste(term[[1]],nb3))) 
    #} else 
    return(nb3)
  } 
  if (is.null(nb3)) {
    #if (inherits(term,"formula")) {   ## idem
    #  return(as.formula(paste(nb2,"~ 0"))) ## return(nb2) would only return the LHS, not a formula 
    #} else 
    return(nb2)
  } 
  term[[2]] <- nb2
  term[[3]] <- nb3
  term
}

.parseBars <- function (term,expand=TRUE,as_character=TRUE) { ## derived from findbars, ... return strings
  if (inherits(term,"formula") && length(term) == 2L) ## added 2015/03/23
    return(.parseBars(term[[2]], expand=expand, as_character=as_character))  ## process RHS
  if (is.name(term) || !is.language(term)) 
    return(NULL)
  if (term[[1]] == as.name("(")) ## i.e. (blob) but not ( | ) 
  {return(.parseBars(term[[2]],expand=expand, as_character=as_character))} 
  if (!is.call(term)) 
    stop("term must be of class call")
  if (term[[1]] == as.name("|")) { ## i.e.  .|. expression
    if (expand) term <- .spMMexpandSlash(term) ## 06/2015
    if (as_character) {
      term <- paste("(",c(term),")")
      attr(term,"type") <- rep("(.|.)",length(term)) ## Random-slope models are not best identified here [(X2-1|block) is not randomslope].
    } else attr(term,"type") <- rep("(.|.)",length(paste(c(term)))) ## paste is the simplest way to count terms (rather than elements of a single term)
    # OK b in a sense inconstistent: the type is attr to the vector not to each of its elements. 
    return(term)
  } ## le c() donne .|. et non |..
  if (length(term) == 2) {
    term1 <- as.character(term[[1]])
    if (term1 %in% c("adjacency","Matern","Cauchy","AR1","corrMatrix")) {
      if (as_character) term <- paste(c(term)) ## formats nicely a multiline long RHS
      attr(term,"type") <- term1
      return(term) 
    } else return(NULL) 
  }
  bT2 <- .parseBars(term[[2]],expand=expand, as_character=as_character)
  bT3 <- .parseBars(term[[3]],expand=expand, as_character=as_character)
  res <- c(bT2, bT3)
  attr(res,"type") <- c(attr(bT2,"type"),attr(bT3,"type"))
  return(res)
}

## spaces should be as in parseBars because terms can be compared as strings in later code
.findSpatial <- function (term, expand=FALSE, as_character=FALSE, nomatch=NULL) { ## derived from findbars
  res <- .parseBars(term, expand=expand, as_character=as_character)
  if (is.null(nomatch)) {
    res <- res[attr(res,"type")!="(.|.)"] ## nomatch=NULL removes terms of type "(.|.)" 
  } else res[attr(res,"type")=="(.|.)"] <- nomatch ## typically sets to nomatch=NA the terms of type "(.|.)" 
  return(res)
}

.findOffset <- function (term) { ## derived from findbars
  if (is.name(term) || !is.language(term)) 
    return(NULL)
  if (term[[1]] == as.name("(")) ## i.e. (blob) but not ( | )
    return(.findOffset(term[[2]])) 
  if (!is.call(term)) 
    stop("term must be of class call")
  if (term[[1]] == as.name("|")) ## i.e. ( | ) expression
    return(NULL)
  if (length(term) == 2) {
    term1 <- as.character(term[[1]])
    if (term1=="offset") {
      return(term) 
    } else if (term1=="~") { 
      return(.findOffset(term[[2]]))
    } else return(NULL) 
  }
  c(.findOffset(term[[2]]), .findOffset(term[[3]]))
}


.asNoCorrFormula <- function(formula) {
  aschar <- .DEPARSE(formula)
  aschar <- gsub("adjacency(","(",aschar,fixed=TRUE)
  aschar <- gsub("Matern(","(",aschar,fixed=TRUE)
  aschar <- gsub("Cauchy(","(",aschar,fixed=TRUE)
  aschar <- gsub("AR1(","(",aschar,fixed=TRUE)
  aschar <- gsub("corrMatrix(","(",aschar,fixed=TRUE)
  as.formula(aschar)
}

## function that handles prior.weights too:
.getValidData <- function(formula,resid.formula=NULL,data,
                         callargs=list() ## expects a list from callargs, ie match.call of the parent frame, 
                                         ## rather than an element, to avoid premature eval of refs to data variables 
                         ) {
  ## 
  envform <- environment(formula)  
  ## The aim is to reduce environment(formula) to almost nothing as all vars should be in the data. 
  #  The revised Infusion code shows how to use the 'data' tfor prior.weights in programming, using eval(parse(text=paste(<...>,priorwName,<...>)))
  # As long as prior.weights was still using the environment, fitting functions still had
  #     mc <- oricall
  #     oricall$formula <- .stripFormula(formula) ## Cf comment in .getValidData
  #  (stripping of mc$formula being done only later by .stripTerms() )
  #  where we otherwise have 
  #     oricall$formula <- .stripFormula(formula) 
  #     mc <- oricall
  formula <- .asNoCorrFormula(formula) ## removes spatial tags
  frame.form <- .subbarsMM(formula) ## this comes from lme4 and converts (...|...) terms to some "+" form
  if (!is.null(resid.formula)) {
    resid.formula <- .asNoCorrFormula(resid.formula) ## removes spatial tags
    frame.resid.form <- .subbarsMM(resid.formula) ## this comes from lme4 and converts (...|...) terms to some "+" form
    frame.form <- paste(.DEPARSE(frame.form),"+",.DEPARSE(frame.resid.form[[2]]))
  }
  check <- grep('$',frame.form,fixed=TRUE)
  if (length(check)) {
    warning("'$' detected in formula: unnecessary and best avoided. 
            One never needs to specify the 'data' in the 'formula'. 
            See help('good-practice') for explanations.")
  }
  frame.form <- as.formula(frame.form)
  environment(frame.form) <- envform
  mf <- match.call()
  m <- match(c("data"), names(mf), 0L)
  mf <- mf[c(1L, m)]
  mf$weights <- callargs$prior.weights
  mf$drop.unused.levels <- TRUE
  mf[[1L]] <- get("model.frame", asNamespace("stats"))
  mf$formula <- frame.form
  mf <- eval(mf)
  return(mf) ## data.frame with many attributes
}

.find_validname <- function(formula, data) {
  ## implies that the var designated by a string (phi, for example) should not be in the data frame 
  respname <- formula[[2]]
  if (is.null(data[[respname]])) {
    validname <- respname
  } else {
    datanames <- names(data)
    allphis <- datanames[which(substr(datanames,0,nchar(respname))==respname)] ## "phi..."
    allphis <- substring(allphis,nchar(respname)+1) ## "..."
    allphis <- as.numeric(allphis[which( ! is.na(as.numeric(allphis)))  ]) ## as.numeric("...")
    if (length(allphis) == 0) {
      num <- 0
    } else num <- max(allphis)+1
    validname <-paste0( respname , num) 
  }
  return(validname)
}

## cf model.frame.default from package stats mais ne traite pas les effets alea !
.HLframes <- function (formula, data) {
  ## m gives either the position of the matched term in the matched call 'mc', or 0
  formula <- .asNoCorrFormula(formula) ## strips out the spatial information, retaining the variables
  if (is.character(formula[[2]])) {
    validname <- .find_validname(formula, data)
    data[validname] <- 1 ## adds a column $phi of 1 
    formula[[2]] <- as.name(validname) ## now the formula is standard
  }
  ####### first construct a mf for all variables required by the formula (NA would be removed here if they had not been by a previous call to validData)
  frame.form <- .subbarsMM(formula) ## this comes from lme4 and converts (...|...) terms to some "+" form 
  environment(frame.form) <- environment(formula)
  fe <- call("model.frame", data=data, formula=frame.form,  drop.unused.levels=TRUE) # language object reused later
  mf <- eval(fe) ## data.frame with all vars required for fixef and for ranef, and a "terms" attribute
  #
  Y <- model.response(mf, "any")
  if ( ! is.null(Y)) { ## exclude this cases which occurs when no LHS formula is handled
    if (is.factor(Y)) { 
      Y <- (Y != levels(Y)[1]) ## cf ?glm: ‘success’ is interpreted as the factor not having the first level
    } ## indeed as in  binomial()$initialize
    if (NCOL(Y)==1L) { ## test on NCOL excludes the case cbind-LHS -> matrix Y (with any array1d stuff already erased)
      Y <- as.matrix(Y) ## to cope with array1d, and see $y <- ... code in .preprocess
    }
  }
  #
  fixef.form <- .stripRanefs_(formula) 
  fixef.form <- .stripOffset_(fixef.form) 
  if (inherits(fixef.form, "formula")) {
    fe$formula <- fixef.form
    fe <- eval(fe)
    fixef_terms <- attr(fe, "terms")
    if (is.null(fixef_terms)) {
      message("Note: formula without explicit fixed effects is interpreted
              as formula without fixed effects (i.e., ~ 0 + (random effects).
              Use ~ 1 + (random effect) rather than ~ (random effect) to include an Intercept.")
    }
    not_any_fixed_effect <- (is.null(fixef_terms) ## y ~ (1 | grp)
                             || fixef_terms[[length(fixef_terms)]]==0) ## y ~0+ (1|grp)
    if (not_any_fixed_effect) { 
      X <- matrix(nrow=nrow(mf),ncol=0L) ## model without fixed effects, not even an Intercept 
    } else {
      X <- model.matrix(fixef_terms, mf, stats::contrasts) 
    } 
    fixef_levels <- stats::.getXlevels(fixef_terms, fe) ## added 2015/12/09 useful for .calc_newFrames()
    } else {
      X <- matrix(nrow=nrow(data), ncol=0L) ## Not using NROW(Y) which is 0 if formula has no LHS
      fixef_terms <- fixef_levels <- NULL
    }
  ####### Then constructs the design X by evaluating the model frame (fe) with fe$formula <- fixef.form
  storage.mode(X) <- "double" ## otherwise X may be logi[] rather than num[] in particular when ncol=0
  list(Y = Y, 
       X = X, 
       wts = NULL, 
       off = NULL, 
       mf = mf, 
       ## only fixef-related variables, contrary to the attr(mf,"terms): 
       fixef_levels = fixef_levels, ## added 2015/12/09 useful for .calc_newFrames()
       fixef_terms = fixef_terms ## added 2015/12/09 useful for .calc_newFrames()
  )
}

.calc_newpredvars <- function(oldterms, formula) {
  predvars <- attr(oldterms, "predvars") ## coming from attr(HLframes$mf, "terms")
  if ( ! is.null(predvars)) { 
    newterms <- terms(formula)
    newtermnames <- rownames(attr(newterms,"factors"))
    oldtermnames <- rownames(attr(oldterms,"factors"))
    textnewform <- .DEPARSE(formula)
    newpredvars <- character(length(newtermnames))
    for (it in seq_len(length(newtermnames))) {
      oldpos <- which(oldtermnames==newtermnames[it])
      newpredvars[it] <- .DEPARSE(predvars[-1][[oldpos]])
    }
    newpredvars <- paste0("list(",paste(newpredvars,collapse=","),")")
    return(parse(text=newpredvars)) ## contains poly(., coefs) information,
  } else return(NULL)
}

.calc_newFrames_fixed <- function (formula, data, fitobject, need_allFrames=TRUE) {
  fixef_terms <- fitobject$HLframes$fixef_terms
  not_any_fixed_effect <- ( is.null(formula) ## .stripRanefs( ~ <rhs without fixef> )
                            || is.null(fixef_terms) ## y ~ (1 | grp)
                           || fixef_terms[[length(fixef_terms)]]==0) ## y ~0+ (1|grp)
  if (not_any_fixed_effect) { 
    X <- matrix(nrow=nrow(data),ncol=0L) ## model without fixed effects, not even an Intercept 
    fixef_mf <- NULL
  } else {
    formula <- .asNoCorrFormula(formula) ## strips out the correlation information, retaining the ranefs as (.|.)
    if (is.character(formula[[2]])) { ## something like ".phi" ....
      validname <- .find_validname(formula, data)
      data[validname] <- 1 ## adds a column $phi of 1 
      formula[[2]] <- as.name(validname) ## now the formula is standard
    }
    Terms <- terms(stats::delete.response(formula))
    attr(Terms,"predvars") <- .calc_newpredvars(fixef_terms, formula) ## for poly()
    fixef_mf <- model.frame(Terms, data, xlev = fitobject$HLframes$fixef_levels) ## xlev gives info about the original levels
    X <- model.matrix(Terms, fixef_mf, contrasts.arg=attr(fitobject$X.pv,"contrasts")) 
    ## : original contrasts definition is used to define X cols that match those of original X, whatever was the contrast definition when the model was fitted
  }
  #
  storage.mode(X) <- "double" ## otherwise X may be logi[] rather than num[] in particular when ncol=0
  return(list(X = X, mf = fixef_mf)) 
}

.calc_newFrames_ranef <- function (formula, data, fitobject) {
  formula <- .asNoCorrFormula(formula) ## strips out the correlation information, retaining the ranefs as (.|.)
  if (is.character(formula[[2]])) {
    validname <- .find_validname(formula, data)
    data[validname] <- 1 ## adds a column $phi of 1 
    formula[[2]] <- as.name(validname) ## now the formula is standard
  }
  plusForm <- .subbarsMM(formula) ## this comes from lme4 and converts (.|.) terms to (.+.) form 
  environment(plusForm) <- environment(formula)
  Terms <- terms(stats::delete.response(plusForm))
  attr(Terms,"predvars") <- .calc_newpredvars(fitobject$HLframes$all_terms, Terms) ## for poly in ranefs ? which never worked
  mf <- model.frame(Terms, data, drop.unused.levels=TRUE) 
  #print(head(mf))
  return(list(mf = mf))
}
