% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{getGlottalCycles}
\alias{getGlottalCycles}
\title{Divide f0 contour into glottal cycles}
\usage{
getGlottalCycles(pitch, samplingRate)
}
\arguments{
\item{pitch}{a vector of fundamental frequency values}

\item{samplingRate}{sampling rate at which f0 values are provided}
}
\description{
Internal soundgen function.
}
\details{
Returns a vector of indices giving the borders between "glottal cycles",
assuming that we know the true f0 at each time point (as we do in synthesized
sounds). The first index is always 1.
}
\examples{
# 100 ms of audio with f0 steadily increasing from 150 to 200 Hz
soundgen:::getGlottalCycles(seq(150, 200, length.out = 350),
  samplingRate = 3500)
}
\keyword{internal}
