% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{getFrameBank}
\alias{getFrameBank}
\title{Frame bank}
\usage{
getFrameBank(sound, samplingRate, windowLength_points, wn, step, zp,
  filter = NULL)
}
\arguments{
\item{sound}{numeric vector}

\item{samplingRate}{sampling rate of \code{x} (only needed if
\code{x} is a numeric vector, rather than a .wav file)}

\item{windowLength_points}{length of fft window (points)}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{zp}{window length after zero padding, points}

\item{filter}{fft window filter (defaults to NULL)}
}
\value{
A matrix with \code{nrow = windowLength_points/2} and \code{ncol}
  depending on \code{length(sound)} and \code{step}
}
\description{
Internal soundgen function.
}
\details{
A subroutine of \code{\link{spec}} that saves windowed (and optionally
zero-padded) frames, i.e. chunks of the sound file of the right size and
spacing. Handy for further processing.
}
\examples{
a = soundgen:::getFrameBank(sin(1:1000), 16000, 512, 'gaussian', 15, 0)
}
\keyword{internal}
