% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSSURGO.R
\name{createSSURGO}
\alias{createSSURGO}
\title{Create a database from SSURGO Exports}
\usage{
createSSURGO(
  filename = NULL,
  exdir,
  conn = NULL,
  pattern = NULL,
  include_spatial = TRUE,
  include_tabular = TRUE,
  dissolve_field = NULL,
  maxruledepth = 0,
  overwrite = FALSE,
  header = FALSE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{filename}{\emph{character}. Output file name (e.g. \code{'db.sqlite'} or \code{'db.gpkg'}). Only used when \code{con} is not
specified by the user.}

\item{exdir}{\emph{character}. Path containing containing input SSURGO spatial (.shp) and tabular (.txt) files,
downloaded and extracted by \code{downloadSSURGO()} or similar.}

\item{conn}{A \emph{DBIConnection} object. Default is a \code{SQLiteConnection} used for writing .sqlite or
.gpkg files. Alternate options are any DBI connection types. When \code{include_spatial=TRUE}, the
sf package is used to write spatial data to the database.}

\item{pattern}{\emph{character}. Optional regular expression to use to filter subdirectories of \code{exdir}.
Default: \code{NULL} will search all subdirectories for SSURGO export files.}

\item{include_spatial}{\emph{logical} or \emph{character}. Include spatial data layers in database?
Default: \code{TRUE} inserts all spatial tables. If \code{include_spatial} is a \emph{character} vector
containing table names, only that set are written to file. e.g. \code{include_spatial=c("mupolygon", "featpoint")} writes only the mapunit polygons and special feature points.}

\item{include_tabular}{\emph{logical} or \emph{character}. Include tabular data layers in database?
Default: \code{TRUE} inserts all tabular tables. If \code{include_tabular} is a \emph{character} vector
containing table names, only that set are written to file. e.g. \code{include_tabular=c("mapunit", "muaggatt")} writes only the \code{mapunit} and \code{muaggatt} tables. Note that special feature
descriptions are stored in table \code{"featdesc"} and metadata for each soil survey area are stored
in \code{"soil_metadata"} tables.}

\item{dissolve_field}{\emph{character}. Dissolve geometries to create MULTIPOLYGON features? Column
name
specified is the grouping variable. Default: \code{NULL} does no aggregation, giving 1 \code{POLYGON}
feature per delineation. \code{"mukey"} aggregates all related delineations within a soil survey
area.}

\item{maxruledepth}{\emph{integer}. Maximum rule depth for \code{"cointerp"} table. Default \code{0} includes only
shallowest ratings for smaller database size.}

\item{overwrite}{\emph{logical}. Overwrite existing layers? Default \code{FALSE} will append to existing
tables/layers.}

\item{header}{\emph{logical}. Passed to \code{read.delim()} for reading pipe-delimited (\code{|}) text files
containing tabular data.}

\item{quiet}{\emph{logical}. Suppress messages and other output from database read/write operations?}

\item{...}{Additional arguments passed to \code{write_sf()} for writing spatial layers.}
}
\value{
Character. Vector of layer/table names in \code{filename}.
}
\description{
The following database types are tested and fully supported:
\itemize{
\item SQLite or Geopackage
\item DuckDB
\item Postgres or PostGIS
}
}
\details{
In theory any other DBI-compatible data source can be used for output. See \code{conn} argument. If
you encounter issues using specific DBI connection types, please report in the soilDB issue
tracker.
}
\examples{
\dontrun{
 downloadSSURGO("areasymbol IN ('CA067', 'CA077', 'CA632')", destdir = "SSURGO_test")
 createSSURGO("test.gpkg", "SSURGO_test")
}
}
\seealso{
\code{\link[=downloadSSURGO]{downloadSSURGO()}}
}
