% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snotel_phenology.r
\name{snotel_phenology}
\alias{snotel_phenology}
\title{Calculates snow phenology from the snow water equivalent data}
\usage{
snotel_phenology(df, threshold = 0)
}
\arguments{
\item{df}{a snotel data file or data frame}

\item{threshold}{threshold for mapping continuous snow cover}
}
\description{
First snow melt, first continuous snow melt, first
snow accumulation and continous snow accumulation
are reported.
}
\details{
Be sure to execute this code on individual sites when loading
a combined tidy data frame containing data for multiple sites.
}
\examples{

\dontrun{
# download one of the longer time series
df <- snotel_download(site_id = 670, internal = TRUE)

# calculate the snow phenology
phenology <- snotel_phenology(df)

# show a couple of lines
head(phenology)

}
}
