% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automagic_tabs.R
\name{automagic_tabs}
\alias{automagic_tabs}
\title{Automatic Generation of Tabs}
\usage{
automagic_tabs(
  input_data,
  panel_name,
  .output,
  ...,
  tabset_title = "",
  tabset_props = ".tabset-fade .tabset-pills",
  is_output_distill = TRUE
)
}
\arguments{
\item{input_data}{Ungrouped tibble with at least 2 columns, one for the title of the tabs and another with
the output to be displayed.}

\item{panel_name}{string with the name of the ID column.}

\item{.output}{string with the name of the column of the output.}

\item{...}{additional parameters that correspond to all those available in rmarkdown chunks
(fig.align, fig.width, ...).}

\item{tabset_title}{string title of the .tabset}

\item{tabset_props}{string defining .tabset properties. Only works with is_output_distill = F}

\item{is_output_distill}{boolean. is output a distill article.}
}
\value{
concatenated string of all automatically generated chunks.
}
\description{
It allows to automatically generate the code necessary to group multiple Rmarkdown chunks
into tabs. Concatenating all the chunks into a string that can be later knitted and rendered.
}
\details{
given a tibble, which must contain an "ID" column (representing the title of the tabs) and another
column that stores the output to be generated (plot, text, code, ...), a string is automatically
generated which can be later rendered in a Rmarkdown document.
}
\examples{

library(dplyr)
library(sknifedatar)
library(ggplot2)

dataset <- iris \%>\% 
  group_by(Species) \%>\% 
  tidyr::nest() \%>\% 
  mutate(
    .plot = purrr::map(data, ~ ggplot(.x, aes(x = Sepal.Length, y = Petal.Length)) + geom_point())
  ) \%>\% 
  ungroup()

automagic_tabs(input_data = dataset, panel_name = "Species", .output = ".plot", fig.align='center')

unlink("figure", recursive = TRUE)
}
\seealso{
\href{https://rafzamb.github.io/sknifedatar/}{sknifedatar website}
}
