% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na}
\alias{replace_na}
\alias{replace_na<-}
\title{Replace NA with specific values}
\usage{
replace_na(x, value, na.label = NULL)

replace_na(x, na.label = NULL) <- value
}
\arguments{
\item{x}{Variable (vector), \code{data.frame} or \code{list} of variables where
missing values should be replaced with \code{value}.}

\item{value}{Value that will replace the \code{\link{NA}}'s.}

\item{na.label}{Optional character vector, used to label the NA-value (i.e.
adding a \code{labels} attribute to \code{x}).}
}
\value{
\code{x}, where \code{NA}'s are replaced with \code{value}.
}
\description{
This function replaces NA's of a variable, data frame
               or list of variables with \code{value}.
}
\note{
Value and variable label attributes (see, for instance, \code{\link{get_labels}}
        or \code{\link{set_labels}}) are preserved.
}
\examples{
data(efc)
table(efc$e42dep, exclude = NULL)
table(replace_na(efc$e42dep, 99), exclude = NULL)

dummy <- list(efc$c82cop1, efc$c83cop2, efc$c84cop3)
# show original distribution
lapply(dummy, table, exclude = NULL)
# show variables, NA's replaced with 99
lapply(replace_na(dummy, 99), table, exclude = NULL)

}
\seealso{
\code{\link{set_na}} for setting \code{NA} values, \code{\link{rec}}
           for general recoding of variables and \code{\link{recode_to}}
           for re-shifting value ranges.
}

