% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabPCA.R
\name{sjt.pca}
\alias{sjt.pca}
\title{Summary of principal component analysis as HTML table}
\usage{
sjt.pca(data, rotation = c("varimax", "oblimin"), nmbr.fctr = NULL,
  fctr.load.tlrn = 0.1, title = "Principal Component Analysis",
  var.labels = NULL, wrap.labels = 40, show.cronb = TRUE,
  show.msa = FALSE, show.var = FALSE, altr.row.col = FALSE, digits = 2,
  string.pov = "Proportion of Variance",
  string.cpov = "Cumulative Proportion", CSS = NULL, encoding = NULL,
  file = NULL, use.viewer = TRUE, no.output = FALSE,
  remove.spaces = TRUE)
}
\arguments{
\item{data}{A data frame that should be used to compute a PCA, or a \code{\link{prcomp}} object.}

\item{rotation}{Rotation of the factor loadings. May be \code{"varimax"} for orthogonal rotation
or \code{"oblimin"} for oblique transformation.}

\item{nmbr.fctr}{Number of factors used for calculating the varimax
rotation. By default, this value is \code{NULL} and the amount of factors is
calculated according to the Kaiser-criteria.}

\item{fctr.load.tlrn}{Specifies the minimum difference a variable needs to have between
factor loadings (components) in order to indicate a clear loading on just one factor and not
diffusing over all factors. For instance, a variable with 0.8, 0.82 and 0.84 factor loading
on 3 possible factors can not be clearly assigned to just one factor and thus would be removed
from the principal component analysis. By default, the minimum difference of loading values
between the highest and 2nd highest factor should be 0.1}

\item{title}{Table caption, as character vector.}

\item{var.labels}{Character vector with variable names, which will be used
to label variables in the output.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{show.cronb}{Logical, if \code{TRUE} (default), the cronbach's alpha value for each factor scale will be calculated,
i.e. all variables with the highest loading for a factor are taken for the
reliability test. The result is an alpha value for each factor dimension.
Only applies when \code{data} is a data frame and no \code{\link{prcomp}} object.}

\item{show.msa}{Logical, if \code{TRUE}, shows an additional column with the measure of sampling adequacy according
dor each component.}

\item{show.var}{Logical, if \code{TRUE}, the proportions of variances for each component as well as cumulative
variance are shown in the table footer.}

\item{altr.row.col}{Logical, if \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{digits}{Numeric, amount of digits after decimal point when rounding estimates and values.}

\item{string.pov}{String for the table row that contains the proportions of variances. By default,
\emph{"Proportion of Variance"} will be used.}

\item{string.cpov}{String for the table row that contains the cumulative variances. By default,
\emph{"Cumulative Proportion"} will be used.}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. For more details,
see \href{../doc/sjtbasic.html}{this package-vignette}, or 'Details' in
\code{\link{sjt.frq}}.}

\item{encoding}{String, indicating the charset encoding used for variable and
value labels. Default is \code{NULL}, so encoding will be auto-detected
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{file}{Destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{Logical, if \code{TRUE}, the HTML table is shown in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{Logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{Logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}),
           \item the html-table with inline-css for use with knitr (\code{knitr}),
           \item the \code{factor.index}, i.e. the column index of each variable with the highest factor loading for each factor and
           \item the \code{removed.items}, i.e. which variables have been removed because they were outside of the \code{fctr.load.tlrn}'s range.
           }
           for further use.
}
\description{
Performes a principle component analysis on a data frame or matrix
               (with varimax or oblimin rotation) and displays the factor solution as HTML
               table, or saves them as file. \cr \cr In case a data frame is used as
               parameter, the Cronbach's Alpha value for each factor scale will be calculated,
               i.e. all variables with the highest loading for a factor are taken for the
               reliability test. The result is an alpha value for each factor dimension.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
\dontrun{
# Data from the EUROFAMCARE sample dataset
library(sjmisc)
data(efc)

# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")
# auto-detection of labels
sjt.pca(efc[, c(start:end)])}

}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjt.pca/}{sjPlot manual: sjt.pca}
           \item \code{\link{sjp.pca}}
         }
}
