% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions.R
\name{adjust_plot_range}
\alias{adjust_plot_range}
\title{Adjust y range of ggplot-objects}
\usage{
adjust_plot_range(gp, upperMargin = 1.05)
}
\arguments{
\item{gp}{A ggplot-object. Usually, this will be returned by most of this
package's plotting functions.}

\item{upperMargin}{Defines the new margin of the upper y-bound of the plot. This value will
be multiplied with \code{gp}'s current total y-range. Default is 1.05, which means
that the upper margin of the new plot's "visible" plot area will be increased
by 5 percent. (i.e. the y-range is 105 percent of the original range,
in order to make all object visible).}
}
\value{
The same ggplot-object, with adjusted y-range, so all graphics and labels
         should be visible.
}
\description{
This method adjusts the y-range of a ggplot-object, which is useful when
               value labels are outside the plot region. A modified ggplot-object will
               be returned with adjusted y-range so everything should be visible.
               Note that this function only works on \code{scale_y_continuous}.
}
\note{
This function only works on \code{scale_y_continuous}.
}
\examples{
# sample data set
library(sjmisc)
data(efc)
# show frequencies of relationship-variable and
# retrieve plot object
gp <- sjp.frq(efc$e15relat, prnt.plot = FALSE)
# show current plot
plot(gp$plot)
# show adjusted plot
adjust_plot_range(gp$plot)

}
\references{
\href{http://blog.ouseful.info/2013/12/03/setting-axis-limits-on-ggplot-charts/}{OUseful.Info (2013)}
}

