% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{sji.SPSS}
\alias{sji.SPSS}
\title{Import SPSS dataset as data frame into R}
\usage{
sji.SPSS(path, enc = NA, autoAttachVarLabels = FALSE,
  atomic.to.fac = FALSE)
}
\arguments{
\item{path}{The file path to the SPSS dataset.}

\item{enc}{The file encoding of the SPSS dataset.}

\item{autoAttachVarLabels}{if \code{TRUE}, variable labels will automatically be
attached to each variable as \code{"variable.label"} attribute.
See \code{\link{sji.setVariableLabels}} for details.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, factor variables imported from
SPSS (which are imported as \code{\link{atomic}}) will be converted
to \code{\link{factor}}s.}
}
\value{
A data frame containing the SPSS data. retrieve value labels with \code{\link{sji.getValueLabels}}
  and variable labels with \code{\link{sji.getVariableLabels}}.
}
\description{
Import data from SPSS, including NA's, value and variable labels.
}
\note{
This is a wrapper function for \code{\link{read.spss}} of the
        \code{foreign} package, using convenient parameter default
        settings.
}
\examples{
# import SPSS data set
# mydat <- sji.SPSS("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- sji.getVariableLabels(mydat)

# retrieve value labels
# mydat.val <- sji.getValueLabels(mydat)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/sji.viewSPSS/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{sji.getValueLabels}}
           \item \code{\link{sji.getVariableLabels}}
           \item \code{\link{sji.convertToLabel}}
           \item \code{\link{sji.convertToValue}}
           \item \code{\link{sji.viewSPSS}}
           }
}

