% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sjp.glmm}
\alias{sjp.glmm}
\title{Plot odds ratios (forest plots) of multiple fitted glm's}
\usage{
sjp.glmm(..., title = NULL, titleSize = 1.3, titleColor = "black",
  labelDependentVariables = NULL, legendDepVarTitle = "Dependent Variables",
  legendPValTitle = "p-level", stringModel = "Model", axisLabels.y = NULL,
  axisLabelSize = 1.1, axisLabelAngle.x = 0, axisLabelAngle.y = 0,
  axisLabelColor = "gray30", axisTitle.x = "Odds Ratios",
  axisTitleSize = 1.2, axisTitleColor = c("#444444"), axisLimits = NULL,
  breakTitleAt = 50, breakLabelsAt = 12, breakLegendAt = 20,
  gridBreaksAt = 0.5, transformTicks = FALSE, errorBarWidth = 0,
  errorBarSize = 0.5, errorBarLineType = 1, pointSize = 3,
  modelPlotSpace = 0.4, colorPalette = "Paired", modelColors = NULL,
  valueLabelColor = "black", valueLabelSize = 4, valueLabelAlpha = 1,
  nsAlpha = 1, usePShapes = FALSE, axisColor = NULL, borderColor = NULL,
  interceptLineType = 2, interceptLineColor = "grey70",
  majorGridColor = NULL, minorGridColor = NULL, hideGrid.x = FALSE,
  hideGrid.y = FALSE, theme = NULL, flipCoordinates = TRUE,
  legendPos = "right", legendSize = 1, legendBorderColor = "white",
  legendBackColor = "white", showIntercept = FALSE,
  showAxisLabels.y = TRUE, showTickMarks = TRUE, showValueLabels = TRUE,
  labelDigits = 2, showPValueLabels = TRUE, printPlot = TRUE)
}
\arguments{
\item{...}{One or more fitted glm-objects.}

\item{title}{Diagram's title as string.
Example: \code{title=c("my title")}}

\item{titleSize}{The size of the plot title. Default is 1.3.}

\item{titleColor}{The color of the plot title. Default is \code{"black"}.}

\item{labelDependentVariables}{Labels of the dependent variables of all fitted models
which have been used as first parameter(s), provided as char vector.}

\item{legendDepVarTitle}{A character vector used for the title of the dependent variable's legend.
Default is \code{"Dependent Variables"}.}

\item{legendPValTitle}{A character vector used for the title of the significance level's legend.
Default is \code{"p-level"}. Only applies if \code{usePShapes} is \code{TRUE}.}

\item{stringModel}{String constant used as legend text for the model names in case no
labels for the dependent variables are provided (see \code{labelDependentVariables}).
Default is \code{"Model"}.}

\item{axisLabels.y}{Labels of the predictor variables (independent vars, odds) that are used for labelling the
axis. Passed as vector of strings.
Example: \code{axisLabels.y=c("Label1", "Label2", "Label3")}
Note: If you use the \code{\link{sji.SPSS}} function and the \code{\link{sji.getValueLabels}} function, you receive a
\code{list} object with label strings. The labels may also be passed as list object. They will be unlisted and
converted to character vector automatically.}

\item{axisLabelSize}{The size of value labels in the diagram. Default is 1.1, recommended values range
between 0.7 and 3.0}

\item{showAxisLabels.y}{Whether odds names (predictor labels) should be shown or not.}

\item{showTickMarks}{Whether tick marks of axes should be shown or not.}

\item{axisTitle.x}{A label ("title") for the x axis.}

\item{axisTitleColor}{The color of the x axis label.}

\item{axisTitleSize}{The size of the x axis label.}

\item{axisLimits}{Defines the range of the axis where the beta coefficients and their confidence intervalls
are drawn. By default, the limits range from the lowest confidence interval to the highest one, so
the diagram has maximum zoom. Use your own values as 2-value-vector, for instance: \code{limits=c(-0.8,0.8)}.}

\item{axisLabelAngle.x}{Angle for axis-labels where the odds ratios are printed. Note
that due to the coordinate flip, the acutal y-axis with odds ratios are appearing on the x-axis.}

\item{axisLabelAngle.y}{Angle for axis-labels where the predictor labels (\code{axisLabels.y}) are printed. Note
that due to the coordinate flip, the acutal x-axis with predictor labels are appearing on the y-axis.}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted}

\item{breakLegendAt}{Wordwrap for legend, i.e. names of the dependent variables of each fitted model.
See parameter \code{labelDependentVariables}. Determines how many chars of each dependent variable name
is displayed in one line in the legend and when a line break is inserted}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is 0.5}

\item{transformTicks}{if \code{TRUE}, the grid bars have exponential distances, i.e. they
visually have the same distance from one grid bar to the next. Default is \code{FALSE} which
means that grids are plotted on every \code{gridBreaksAt}'s position, thus the grid bars
become narrower with higher odds ratio values.}

\item{pointSize}{The size of the points that indicate the beta-value. Default is 3.}

\item{modelPlotSpace}{Defines the space between the dots and error bars of the plotted fitted models. Default
is 0.3.}

\item{modelColors}{A vector with colors for representing the odds values (i.e. points and error bars)
of the different fitted models. Thus, the length of this vector must be equal to
the length of supplied fitted models, so each model is represented by its own color.
You can use:
\itemize{
  \item \code{"bw"} or \code{"black"} for only one colouring in almost black
  \item \code{"gray"}, \code{"grey"} or \code{"gs"} for a grayscale
  \item \code{"brewer"} for colours from the color brewer palette.
  }
If \code{modelColors} is \code{"brewer"}, use the \code{colorPalette} parameter to specify a palette of the \url{http://colorbrewer2.org}
Else specify your own color values as vector (e.g. \code{modelColors=c("#f00000", "#00ff00")}).}

\item{colorPalette}{If parameter \code{modelColors} is \code{brewer}, specify a color palette from the \url{http://colorbrewer2.org} here.
All color brewer palettes supported by ggplot are accepted here.}

\item{axisLabelColor}{Colour of the tick labels at the axis (variable names, odds names).}

\item{valueLabelColor}{The colour of the odds values. These values are printed above the plots respectively beside the
bar charts. default color is \code{"black"}.}

\item{valueLabelSize}{Size of the value labels. Drfault is 4. Recommended Values range from
2 to 8}

\item{valueLabelAlpha}{The alpha level (transparancy) of the value labels. Default is 1, use
any value from 0 to 1.}

\item{nsAlpha}{The alpha level (transparancy) of non significant predicors. Points and error bars
are affected by this value and plotted with a slight transparancy. Default is 1.}

\item{usePShapes}{If \code{TRUE}, significant levels are distinguished by different point shapes and a related
legend is plotted. Default is \code{FALSE}.}

\item{axisColor}{User defined color of axis border (y- and x-axis, in case the axes should have different colors than
the diagram border).}

\item{borderColor}{User defined color of whole diagram border (panel border).}

\item{interceptLineType}{The linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{The color of the intercept line. Default value is \code{"grey70"}.}

\item{errorBarWidth}{The width of the error bar ends. Default is \code{0}}

\item{errorBarSize}{The size (thickness) of the error bars. Default is \code{0.5}}

\item{errorBarLineType}{The linetype of error bars. Default is \code{1} (solid line).}

\item{majorGridColor}{Specifies the color of the major grid lines of the diagram background.}

\item{minorGridColor}{Specifies the color of the minor grid lines of the diagram background.}

\item{hideGrid.x}{If \code{TRUE}, the x-axis-gridlines are hidden. Default if \code{FALSE}.}

\item{hideGrid.y}{If \code{TRUE}, the y-axis-gridlines are hidden. Default if \code{FALSE}.}

\item{theme}{Specifies the diagram's background theme. Default (parameter \code{NULL}) is a gray
background with white grids.
\itemize{
\item Use \code{"bw"} for a white background with gray grids
\item \code{"classic"} for a classic theme (black border, no grids)
\item \code{"minimal"} for a minimalistic theme (no border,gray grids) or
\item \code{"none"} for no borders, grids and ticks.
}}

\item{flipCoordinates}{If \code{TRUE} (default), predictors are plotted on the left y-axis and estimate
values are plotted on the x-axis.}

\item{legendPos}{The position of the legend, if a legend is drawn. Use \code{"bottom"}, \code{"top"}, \code{"left"}
or \code{"right"} to position the legend above, below, on the left or right side of the diagram. Right
positioning is default.}

\item{legendSize}{The text size of the legend. Default is 1. Relative size, so recommended values are from 0.3 to
2.5}

\item{legendBorderColor}{Color of the legend's border. Default is \code{"white"}, so no visible border is drawn.}

\item{legendBackColor}{Fill color of the legend's background. Default is \code{"white"}, so no visible background is drawn.}

\item{showIntercept}{If \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}. Please note that due to exp-transformation of
estimates, the intercept in some cases can not be calculated, thus the
function call is interrupted and no plot printed.}

\item{showValueLabels}{Whether the beta and standardized beta values should be plotted
to each dot or not.}

\item{labelDigits}{The amount of digits for rounding the estimations (see \code{showValueLabels}).
Default is 2, i.e. estimators have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot odds ratios (forest plots) of multiple fitted glm's with confidence intervalls in one plot.
}
\examples{
# prepare dummy variables for binary logistic regression
y1 <- ifelse(swiss$Fertility<median(swiss$Fertility), 0, 1)
y2 <- ifelse(swiss$Infant.Mortality<median(swiss$Infant.Mortality), 0, 1)
y3 <- ifelse(swiss$Agriculture<median(swiss$Agriculture), 0, 1)

# Now fit the models. Note that all models share the same predictors
# and only differ in their dependent variable (y1, y2 and y3)
fitOR1 <- glm(y1 ~ swiss$Education+swiss$Examination+swiss$Catholic,
              family=binomial(link="logit"))
fitOR2 <- glm(y2 ~ swiss$Education+swiss$Examination+swiss$Catholic,
              family=binomial(link="logit"))
fitOR3 <- glm(y3 ~ swiss$Education+swiss$Examination+swiss$Catholic,
              family=binomial(link="logit"))

# plot multiple models
sjp.glmm(fitOR1, fitOR2, fitOR3)

# plot multiple models with legend labels and point shapes instead of value  labels
sjp.glmm(fitOR1, fitOR2, fitOR3,
         labelDependentVariables=c("Fertility", "Infant Mortality", "Agriculture"),
         showValueLabels=FALSE,
         showPValueLabels=FALSE,
         usePShapes=TRUE,
         nsAlpha=0.2)
}
\references{
\itemize{
             \item \url{http://strengejacke.wordpress.com/sjplot-r-package/}
             \item \url{http://strengejacke.wordpress.com/2014/01/29/comparing-multiple-glm-in-one-graph-rstats/}
            }
}
\seealso{
\code{\link{sjp.glm}} \cr
         \code{\link{sjt.glm}} \cr
         \code{\link{sjp.glm.ma}} \cr
         \code{\link{sjp.lmm}}
}

