% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_sex_semanaepi}
\alias{agrupar_sex_semanaepi}
\title{Agrupar por sexo, semana epidemiológica y casos}
\usage{
agrupar_sex_semanaepi(
  data_event,
  cols_sex = c("sexo", "semana"),
  porcentaje = TRUE
)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de
la enfermedad o evento.}

\item{cols_sex}{Un `character` (cadena de caracteres) o
`array` (arreglo) de `character` con el nombre de la(s)
columna(s) que contienen el sexo y las semanas
epidemiológicas; su valor por defecto es `c("sexo", "semana")`.}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica si se debe
agregar una columna con el porcentaje de casos; su valor por
defecto es `TRUE`.}
}
\value{
Un `data.frame` con los datos de la enfermedad o evento
agrupados por sexo, semana epidemiológica y número de casos.
}
\description{
Función que agrupa los datos de enfermedades por sexo,
semana epidemiológica y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_sex_semanaepi(
  data_event = data_limpia,
  cols_sex = c("sexo", "semana"),
  porcentaje = TRUE
)
}
