% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{updateDefAdd}
\alias{updateDefAdd}
\title{Update definition table}
\usage{
updateDefAdd(
  dtDefs,
  changevar,
  newformula = NULL,
  newvariance = NULL,
  newdist = NULL,
  newlink = NULL,
  remove = FALSE
)
}
\arguments{
\item{dtDefs}{Definition table that will be modified}

\item{changevar}{Name of field definition that will be changed}

\item{newformula}{New formula definition (defaults to NULL)}

\item{newvariance}{New variance specification (defaults to NULL)}

\item{newdist}{New distribution definition (defaults to NULL)}

\item{newlink}{New link specification (defaults to NULL)}

\item{remove}{If set to TRUE, remove definition (defaults to FALSE)}
}
\value{
A string that represents the desired formula
}
\description{
Updates row definition table created by functions
defDataAdd and defReadAdd. (For tables created using defData
or defRead use updateDef.)
}
\examples{

# Define original data

defs <- defData(varname = "w", formula = 0, variance = 3, dist = "normal")
defs <- defData(defs, varname = "x", formula = "1 + w", variance = 1, dist = "normal")
defs <- defData(defs, varname = "z", formula = 4, variance = 1, dist = "normal")

# Define additional columns

defsA <- defDataAdd(varname = "a", formula = "w + x + z", variance = 2, dist = "normal")

set.seed(2001)
dt <- genData(10, defs)
dt <- addColumns(defsA, dt)
dt

# Modify definition of additional column

defsA <- updateDefAdd(dtDefs = defsA, changevar = "a", newformula = "w+z", newvariance = 1)

set.seed(2001)
dt <- genData(10, defs)
dt <- addColumns(defsA, dt)
dt
}
\concept{define_data}
\concept{utility}
