% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-covmat.R
\name{cov_plot_data}
\alias{cov_plot_data}
\title{Prepare data for Plotting Covariance Matrix}
\usage{
cov_plot_data(sobj, type = "relpos", ordering = TRUE,
  facetting = TRUE)
}
\arguments{
\item{sobj}{A simrel object}

\item{type}{Type of covariance matrix - can take two values \code{relpos} for relevant position
of principal components  and \code{relpred} for relevant position of predictor variables}

\item{ordering}{TRUE for ordering the covariance for block diagonal display}

\item{facetting}{TRUE for facetting the predictor and response space. FALSE will give a single facet plot}
}
\value{
A data frame with covariances and related values based on \code{type} argument that is  ready to plot
}
\description{
Prepare data for Plotting Covariance Matrix
}
\examples{
sobj <- simrel(n = 100, p = 10, q = c(4, 5), relpos = list(c(1, 2, 3), c(4, 6, 7)), m = 3,
               R2 = c(0.8, 0.7), ypos = list(c(1, 3), 2), gamma = 0.7, type = "multivariate")
head(cov_plot_data(sobj))
}
\keyword{covariance}
\keyword{data,}
\keyword{linear}
\keyword{model}
\keyword{model,}
\keyword{plot}
\keyword{simulation,}
